<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Loan extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
	}

	
	public function index()
	{
		$crud = $this->generate_crud('loans');
		 $crud->set_relation('name', 'employees', 'Full_Name');
		  $crud->field_type('employee_id', 'hidden');
 		 $crud->field_type('paid', 'hidden');
  		 $crud->field_type('balance', 'hidden');
         $crud->field_type('status', 'hidden');
         $crud->field_type('interest_amount', 'hidden');
         $crud->field_type('total_loan', 'hidden');
         $crud->field_type('loan_ref_code', 'hidden');

		  $crud->set_relation('loan_type', 'loan_types', 'type'); 

		 $crud->add_action('Add Payment', '', 'admin/loan/repayment','fa fa-money');

         $crud->callback_before_insert(array($this,'loan_callback'));
         $crud->callback_before_update(array($this,'loan_callback'));
		
		//$crud->unset_edit();
		//$crud->unset_delete();

		$this->mPageTitle = 'Employees Loans';
		$this->render_crud();
	}



	public function types()
	{
		$crud = $this->generate_crud('loan_types');
		$this->mPageTitle = 'Employees Loans';
		$this->render_crud();
	}

//loan callback 

	public function loan_callback($post_array){

	    $name =	 $post_array['name']  ;

		$query = $this->db->get_where('employees', array('id'=>$name)); 

        $post_array['employee_id'] = $query->row('Employee_Id');

         $type =	 $post_array['loan_type']  ;

		$query2 = $this->db->get_where('loan_types', array('id'=>$type));

			$rate = $query2->row('interest');
			$rate2 = $rate * 0.01;

			$interest_amount = $post_array['loan_amount']  * $rate2 ;

			$post_array['interest_amount'] = $interest_amount ;

			$totaloan =  $interest_amount + $post_array['loan_amount']  ;



        $post_array['status'] = "NOT PAID";

        $post_array['total_loan'] = $totaloan;

        $post_array['balance'] = $totaloan; 
        
        $post_array['loan_ref_code'] =  time(); 
	    
	    return $post_array;


	}


	public function repayment ($primary_key){
	
		

		$this->mViewData['primarykey'] = $primary_key;
		$this->render('loan_repayment');


	}



	public function addrepayment(){

		$user  = $this->input->post('user');



		$empname = $this->input->post('name');

		$loanid  = $this->input->post('primarykey');
		$empid   = $this->input->post('empid');

		$paymentmethod = $this->input->post('paymentmethod');
		$balance  = $this->input->post('balance');
		$paid  = $this->input->post('paid');
		$amountpaid = $this->input->post('amountpaid');
		$totaloan = $this->input->post('total');
		
		$newbalance=0;
		$newbalance=$balance-$amountpaid;
		$newpaid = $paid+$amountpaid;

		$paymentrefcode = time();

		$loanrefcode = $this->input->post('loanrefcode');

		if( $newbalance == 0){

			$status = "FULLY PAID" ;
		}

		else if ( $newbalance > 0){

			$status = "PARTIALY PAID" ;

		}

		else if ( $newbalance < 0){

			$status = "OVER PAID" ;

		}




		$date = date('Y-m-d');

		$postedby = $user; 


		$data = array(

			'payment_ref_code' => $paymentrefcode,
			'loan_ref_code' => $loanrefcode,
			'loan_id' => $loanid,
			'employee_id' =>$empid,
			'full_name' => $empname,
			'loan_amount' => $totaloan,			
			'paid' => $newpaid,
			'balance' => $newbalance,
			'amount_paid' =>$amountpaid,
			'payment_method' =>$paymentmethod,
			'date' =>$date,
			'posted_by' => $user,
			'status' => $status,


		);



		$this->db->insert('loan_payments', $data);

		$data2 = array(

									
			'paid' => $newpaid,
			'balance' => $newbalance,
			'status' => $status,
			


		);

		$this->db->where('id', $loanid);

		$this->db->update('loans', $data2);

		redirect('admin/loan');

	}





	public function payments()
	{

	 $crud = $this->generate_crud('loan_payments');

	 $crud->add_action('Reverse Payment', '', 'admin/loan/reverse','fa fa-arrow-right ');


       $crud->unset_add();
       $crud->unset_edit();
       $crud->unset_delete();

		$this->mPageTitle = 'Employees Loans Payments';
		$this->render_crud();
	}






	public function reverse ($primary_key){
		

		$this->mViewData['primarykey'] = $primary_key;
		$this->mViewData['notification'] = "Employee Loan Repayment Reversal <br> Make Transaction Reversal: Full Amount or Partial";


		$this->render('reverse');


	}



	public function reversepayments()
		{

		 $crud = $this->generate_crud('loan_payment_reversals');



	       $crud->unset_add();
	       $crud->unset_edit();
	       $crud->unset_delete();

			$this->mPageTitle = 'Employees Loans Reversal Payments ';

			$this->render_crud();
		}



	public function addreverse (){


		$user  = $this->input->post('user');

		$loanid  = $this->input->post('loanid');

		$paymentrefcode  = $this->input->post('paymentrefcode');
		$loanrefcode  = $this->input->post('loanrefcode');
		$paymentid  = $this->input->post('paymentid');

		$balance = $this->input->post('balance');

		$paid = $this->input->post('paid');

		$reverseamount  = $this->input->post('reverseamount');

		$amountpaid = $this->input->post('amountpaid');

		$totaloan = $this->input->post('total');

		$newbalance = $balance+$reverseamount;

		$newpaid = $paid-$reverseamount;

		$reversalrefcode = time();

		$date = date('Y-m-d');


		if($reverseamount > $amountpaid )

		{

		//$this->mViewData['primarykey'] = $paymentid;
		//$this->mViewData['notification'] = "No";


		//$this->render('reverse');

			$status = "NO";
		}

		

		if( $newbalance == 0 ){

			$status = "FULLY PAID" ;
		}


		else if ( $newbalance == $totaloan){

			$status = "NOT PAID" ;

		}
		
		else if ( $newbalance > 1 && $newbalance < $totaloan){

			$status = "PARTIALY PAID" ;

		}

				

		else if ( $newbalance < 0){

			$status = "OVER PAID" ;

		}



			$data = array(

			'balance' =>$newbalance,
			'paid' => $newpaid,			
			'status' => $status,


		);

	
		$this->db->where('id', $loanid);

		$this->db->update('loans', $data);

		$data2 = array(

			'date' =>$date,
			'reversal_ref_code' =>$reversalrefcode,
			'loan_ref_code'  => $loanrefcode,
			'payment_ref_code' =>$paymentrefcode,
			'loan_total_amount' =>$totaloan,
			'loan_previous_balance' =>$balance,
			'transaction_amount_paid' =>$amountpaid,
			'amount_reversed' =>$reverseamount,
			'loan_new_balance' =>$newbalance,
			'posted_by' =>$user,
				


		);

		$this->db->insert('loan_payment_reversals', $data2);

		$newamountpaid = $amountpaid-$reverseamount;
		$newtotalpaid = $paid-$reverseamount;


		$data3 = array(

			'amount_paid' => $newamountpaid,
			'paid' =>$newtotalpaid,
			'balance' =>$newbalance,
			'status' => 'Reversed  '.$reverseamount,
			
		);


		$this->db->where('id', $paymentid);
		$this->db->update('loan_payments', $data3);


		redirect('admin/loan/reversepayments');


		}
	
}
