<?php
class Properties extends Admin_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('properties_model');
    }
    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $office = $user->office;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $usergroup = $query->row('group_id');
        $this->mViewData['usergroup'] = $query->row('group_id');
        if ($usergroup == 1 || $usergroup == 2) {
            $this->mViewData['properties'] = $this->properties_model->get_all_properties();
        } else {
            $query = $this->db->get_where('property', array('branch_id' => $office));
            $this->mViewData['properties'] = $query->result();
        }
        $this->render('_layouts/property');
    }
    public function add() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        //$this->mViewData['landlords'] = $this->landlords_model->get_all_landlords();
        $this->render('_layouts/addProperty');
    }
    public function property_add() {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('property_name', 'Property Name', 'required');
        $this->form_validation->set_rules('location', 'Location', 'required');
        $this->form_validation->set_rules('property_type', 'Property Type', 'required');
        $this->form_validation->set_rules('landlord_id', 'Landlord Name', 'required');
        $this->form_validation->set_rules('office_branch', 'Office Branch', 'required');
        $this->form_validation->set_rules('commission', 'Commission', 'required');
        if ($this->form_validation->run() == FALSE) {
            echo validation_errors();
        } else {
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $data = array('landlord_id' => $this->input->post('landlord_id'), 
                          'branch_id' => $this->input->post('office_branch'), 
                          'property_name' => $this->input->post('property_name'), 
                          'location' => $this->input->post('location'), 
                          'branch_id' => $this->input->post('office_branch'), 
                          'property_type' => $this->input->post('property_type'), 
                          'water_deposit' => $this->input->post('water_deposit'), 
                          'electricity_deposit' => $this->input->post('electricity_deposit'), 
                          'commission' => $this->input->post('commission'), 
                          'record_creator' => $username);
            $insert = $this->db->insert('property', $data);
            if ($insert == true) {
                $this->session->set_flashdata('success', "Property added successfully");
                 redirect('admin/properties');
            }else{
                $this->session->set_flashdata('error', "Record Not Inserted");   
            }
            //echo json_encode(array("status" => TRUE));
        }
    }
    public function ajax_edit($id) {
        $data = $this->properties_model->get_by_id($id);
        echo json_encode($data);
    }
    public function property_update() {
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $data = array('landlord_id' => $this->input->post('landlord_id'), 
                      'branch_id' => $this->input->post('office_branch'), 
                      'property_name' => $this->input->post('property_name'), 
                      'location' => $this->input->post('location'), 
                      'property_type' => $this->input->post('property_type'), 
                      'water_deposit' => $this->input->post('water_deposit'), 
                      'electricity_deposit' => $this->input->post('electricity_deposit'), 
                      'commission' => $this->input->post('commission'), 
                      'record_creator' => $username,);
        $this->properties_model->property_update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }
    public function property_delete($id) {
        $this->properties_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }
    public function view_property($id) {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['id'] = $id;
        $this->render('_layouts/viewproperty');
    }
}
