<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Trips extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
        $this->load->model('trips_model');
	}


	public function index()
	{
         $user = $this->ion_auth->user()->row();
         $loggeduserid =  $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id'=>$loggeduserid));
          $this->mViewData['usergroup']  = $query->row('group_id');

        $this->mViewData['trips'] =$this->trips_model->get_all_trips();
        

        		$this->render('_layouts/trip');

    }
    
    public function trip_add(){

        $data = array(
            'date' => $this->input->post('date'),
           'driver' => $this->input->post('driver'),
             'client' => $this->input->post('client'),
             'vehicle' => $this->input->post('vehicle'),
             'tripfrom' => $this->input->post('tripfrom'),
             'tripto' => $this->input->post('tripto'),
            'departure' => $this->input->post('departure'),
            'arrival' => $this->input->post('arrival'),
            'delivery' => $this->input->post('status'), 

        );

        $insert = $this->trips_model->trip_add($data);
        echo json_encode(array("status" => TRUE));
    }
    

    public function ajax_edit($id)
    {
        $data = $this->trips_model->get_by_id($id);

        echo json_encode($data);
    }

    public function trip_update()

    {
        $data = array(


              'date' => $this->input->post('date'),
            'driver' => $this->input->post('driver'),
            'client' => $this->input->post('client'),
            'vehicle' => $this->input->post('vehicle'),
            'tripfrom' => $this->input->post('tripfrom'),
            'tripto' => $this->input->post('tripto'),
            'departure' => $this->input->post('departure'),
            'arrival' => $this->input->post('arrival'),
            'delivery' => $this->input->post('status'),
        );

        $this->trips_model->trip_update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function trip_delete($id){

        $this->trips_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

}
