<div class="container">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-university"></i> Tenants
        </h1>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12 text-right">
                <div class="form-group">
                    <a class="btn btn-primary" onclick="add_tenant()"><i class="fa fa-plus"></i> Add tenant </a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="box">
                <div class="box-body table-responsive no-padding">
                    <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>NAME</th>
                                <th>ID NUMBER</th>
                                <th>PHONE</th>
                                <th>EMAIL</th>
                                <th>House</th>
                                <th>UNIT</th>
                                <th style="width:125px;">Action</th
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($tenants as $tenant) { ?>
                                <tr>
                                    <td><?php echo $tenant->fullname; ?> </td>
                                    <td><?php echo $tenant->idno; ?> </td>
                                    <td><?php echo $tenant->phone; ?> </td>
                                    <td><?php echo $tenant->email; ?> </td>
                                    <td><?php 
                                        $query = $this->db->get_where('property', array('id' => $tenant->property_id));
                                        foreach ($query->result() as $row) {
                                            echo $row->property_name;
                                        }
                                    ?> </td>
                                    <td><?php echo $tenant->unit_code; ?> </td>
                                    <td>
                                        <?php if ($usergroup == 1 || $usergroup == 2) { ?>
                                            <button class="btn btn-success" onclick="edit_tenant(<?php echo $tenant->id; ?>)">Update</i></button>
                                            
                                            <a class="btn btn-primary" href="<?php echo base_url(); ?>admin/tenants/view_tenant/<?php echo $tenant->id; ?>">
                                                <i class="fa fa-eye"></i></a>

                                        <?php } else { ?>

                                             <a class="btn btn-primary" href="<?php echo base_url(); ?>admin/tenants/view_tenant/<?php echo $tenant->id; ?>">
                                                <i class="glyphicon fa fa-eye"></i></a>

                                        <?php } ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div> 
        </div>
</div>

</section>
</div>
<script>
    function toTitleCase(str) {
        return str.replace(/\w*/g, function (txt) {
            return txt.charAt().toUpperCase() + txt.substr(1).toLowerCase();
        });
    }
</script>
<script>
    $(document).ready(function () {
        $("input[type='text']").blur(function () {
            var str = toTitleCase($(this).val());
            str = str.replace(/\s+/g, " ");
            str = str.replace(/(^\s+|\s+$)/g, "");
            $(this).val(str);
        });
    });</script>
<script>
    function isNumber(evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    }
</script>

<script type="text/javascript">
    $(document).ready(function () {
        $('#table_id').DataTable();
    });
    var save_method; //for save method string
    var table;

    function add_tenant()
    {
        save_method = 'add';
        $('#form')[0].reset(); // reset form on modals
        $('#modal_form').modal('show'); // show bootstrap modal
        //$('.modal-title').text('Add Person'); // Set Title to Bootstrap modal title
    }

    function edit_tenant(id)
    {
        save_method = 'update';
        $('#form')[0].reset(); // reset form on modals

        //Ajax Load data from ajax
        $.ajax({
            url: "<?php echo site_url('admin/tenants/ajax_edit/') ?>/" + id,
            type: "GET",
            dataType: "JSON",
            success: function (data)
            {
                $('[name="fullname"]').val(data.fullname);
                $('[name="idno"]').val(data.idno);
                $('[name="phone"]').val(data.phone);
                $('[name="email"]').val(data.email);
                $('[name="id"]').val(data.id);
                $('#modal_form').modal('show'); // show bootstrap modal when complete loaded
                $('.modal-title').text('Edit tenant'); // Set title to Bootstrap modal title

            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error get data from ajax');
            }
        });
    }
    function save()
    {
        var url;
        if (save_method == 'add')
        {
            url = "<?php echo base_url('admin/tenants/tenant_add') ?>";
        } else
        {
            url = "<?php echo site_url('admin/tenants/tenant_update') ?>";
        }

        // ajax adding data to database
        $.ajax({
            url: url,
            type: "POST",
            data: $('#form').serialize(),
            dataType: "JSON",
            success: function (data)
            {
                //if success close modal and reload ajax table
                $('#modal_form').modal('hide');
                location.reload();// for reload a page
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error adding / update data');
            }
        });
    }

    function vacate_tenant(id)
    {
        if (confirm('Are you sure Vacate this tenant?'))
        {
            // ajax delete data from database
            $.ajax({
                url: "<?php echo site_url('admin/tenants/vacate_tenant') ?>/" + id,
                type: "POST",
                dataType: "JSON",
                success: function (data)
                {
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert('Error deleting data');
                }
            });

        }
    }



</script>


<!-- Bootstrap modal -->
<div class="modal fade " id="modal_form" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h3 class="modal-title">Add New tenant</h3>
            </div>
            <div class="modal-body form">
                <form action="#" id="form" class="form-horizontal">
                    <input type="hidden" value="" name="id"/>
                    <div class="form-body">
                        <div class="form-group">
                            <label class="control-label col-md-3">Name *</label><br>
                            <div class="col-md-9">
                                <input name="fullname"  class="form-control" type="text" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label  col-md-3">Id Number *</label><br>
                            <div class="col-md-9">
                                <input name="idno" onkeypress="return isNumber(event)"  class="form-control" type="text" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Phone  *</label><br>
                            <div class="col-md-9">
                                <input name="phone" onkeypress="return isNumber(event)" class="form-control tel" type="text" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Email</label><br>
                            <div class="col-md-9">
                                <input name="email"  class="form-control" type="text">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Property Name  *</label><br>
                            <div class="col-md-9">
                                <select id="property" class="form-control" name="property_id" required>
                                    <option>Select Property</option>
                                    <?php
                                    $query = $this->db->get('property');
                                    foreach ($query->result() as $row) {
                                        ?>
                                        <option value="<?php echo $row->id; ?>">
                                            <?php echo $row->id; ?> -- <?php echo $row->property_name; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Unit  *</label><br>
                            <div class="col-md-9">
                                <select class="form-control" id="unit_id" name="unit_code" required>
                                    <option>Select Unit</option>

                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="btnSave" onclick="save()" class="btn btn-primary">Save</button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- End Bootstrap modal -->
<script src="<?php echo base_url('assests/js/intlTelInput.js') ?>"></script>
<script src="<?php echo base_url('assests/js/validate.js') ?>"></script>


<script type="text/javascript">
                            $(document).ready(function () {
                                $('#property').change(function () {
                                    var id = $(this).val(); // <-- change this line
                                    console.log(id);
                                    $.ajax({
                                        url: "<?php echo site_url('admin/units/ajax_units') ?>/" + id,
                                        type: "POST",
                                        //data: "propertyid=" + id,
                                        dataType: "json",
                                        beforeSend: function () {
                                            $("#unit_id").empty();
                                        },
                                        success: function (data) {
                                            data.forEach(function (units) {
                                                $('#unit_id').append($('<option></option>').text(units));
                                            });
                                        }
                                    });
                                });
                            });


</script>


<script>
    $(function () {
        jQuery.validator.addMethod("isValidPhone", function (value, element) {
            return this.optional(element) || telInput.intlTelInput("isValidNumber");
        }, "* Enter a Valid Number");
        var telInput = $(".tel");
        telInput.intlTelInput({
            autoFormat: true,
            defaultCountry: "ke",
            responsiveDropdown: false,
            utilsScript: "<?php echo base_url('assets/js/utils.js') ?>"
        });
        telInput.keydown(function () {
            telInput.removeClass("error");
        });
    });
</script>
<script type="text/javascript">
    $('input.typeahead').typeahead({
        source: function (query, process) {
            return $.get('admin/tenants/ajaxTenantSearch', {query: query}, function (data) {
                console.log(data);
                data = $.parseJSON(data);
                return process(data);
            });
        }
    });
</script>