<?php

  
    class MYPDF extends TCPDF {
        
   
    
}
// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Joel Mwas');
$pdf->SetTitle('Income Report');
$pdf->SetSubject(' ');
$pdf->SetKeywords('');
$pdf->SetTextColor(0,0,0);
// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('helveticaB', '', 10);

// set cell padding
$pdf->setCellPaddings(1, 1, 1, 1);

// set cell margins
$pdf->setCellMargins(1, 1, 1, 1);

// add a page
$pdf->AddPage();




$html = <<<EOF
<div style="text-align:center; ">
<h2><u>INCOME REPORT</u></h2>
<p>START DATE: $start. END DATE: $end
</div>
EOF;

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');
// -----------------------------------------------------------------------------




// -----------------------------------------------------------------------------

 

// -----------------------------------------------------------------------------

$tbl_header = '
<table style="text-align:center; font-size: 9px;" cellspacing="0" cellpadding="1" border="0.1"  rowspan="5"  >
<p><b>INCOME RECORDS</b>  PROPERTY: '.$ppname.'</p>


<tr style="background-color:#fcfcfc">
    <th><b>INVOICE NO</b></th>
    <th><b>PAYMENT REF</b></th> 
    <th><b>DATE</b></th>
     <th><b>RENT PAID</b></th>
     <th><b>COMMISSION</b></th>
     <th><b>VAT</b></th>
</tr>

';
$tbl_footer = '</table>';
$tbl = '';
 if ($property =='ALL') {
 $query = $this->db->get_where('invoicepayments', array('date >=' => $start, 'date <=' => $end,'status'=>'Paid')); 
}
else {

   $query = $this->db->get_where('invoicepayments', array('date >=' => $start, 'date <=' => $end,'status'=>'Paid', 'propertyid'=>$property));
}
// foreach item in your array...
  foreach ($query->result() as $row)    {
      
      
$tbl .= '
 <tr>
        <td style="border: 1px solid #000000; ">'.$row->invoiceid.'</td>
        <td style="border: 1px solid #000000; ">'.$row->refno.'</td>
        <td style="border: 1px solid #000000; ">'.$row->date.'</td>
        <td style="border: 1px solid #000000; ">'.number_format($row->amount_paid,2).'</td>
        <td style="border: 1px solid #000000; ">'.number_format($row->commission,2).'</td>
        <td style="border: 1px solid #000000; ">'.number_format($row->vat,2).'</td>
 
</tr>
    
';      

}

$pdf->writeHTML($tbl_header . $tbl . $tbl_footer, true, false, false, false, ''); 

// -----------------------------------------------------------------------------
$tbl = <<<EOD

<table style="text-align:center; font-size: 9px;" cellspacing="0" cellpadding="1" border="0"  rowspan="7"  >
   
<tr>
<td></td>
<td></td>
<td></td>
<td border="0.1" ><b>TOTAL RENT <br>$total</b></td>
 <td border="0.1" ><b>TOTAL COMMISSION<br>$totalcomm</b></td>
<td border="0.1" ><b>TOTAL VAT<br>$totalvat</b></td>

</tr>

</table>


EOD;


$pdf->writeHTML($tbl, true, false, false, false, '');

// -----------------------------------------------------------------------------

 

// -----------------------------------------------------------------------------
$tbl = <<<EOD

<table cellspacing="0" cellpadding="0" border="0">
   
<tr>
<td width="450px;"> <i>Authorised Signature: _______________________________________ </i> </td>

</tr>

</table>


EOD;


$pdf->writeHTML($tbl, true, false, false, false, '');

// -----------------------------------------------------------------------------

$html = '

';
$pdf->writeHTML($html, true, false, true, false, '');

// -----------------------------------------------------------------------------

 

//Close and output PDF document
$pdf->Output('Landlord Statement Report.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
  
  