<?php
defined('BASEPATH') OR exit('No direct script access allowed');
//header("Content-Type: application/json");

class Mpesa extends MY_Controller {
    
    
    	public function index()
	{
		$this->render('home', 'full_width');
	}
	
    
    public function c2b($id){
        
         $query = $this->db->get_where('invoices', array('invoice_number'=> $id));
         $this->mViewData['description'] = $query->row('description');
         $this->mViewData['balance'] = $query->row('balance');
         $this->mViewData['invno'] = $id;
         
		
 		$this->render('mpesa_c2b', 'full_width');
 	
  
 	
    }
    
      public function process_c2b(){
          
          $invno = $this->input->post('invno');
          $mpesa_code = $this->input->post('mpesa_code');
        
         $query = $this->db->get_where('mpesa_c2b', array('mpesacode'=> $mpesa_code, 'invno'=>$invno ));
          
         $rows = $query->num_rows();
         
         
         if ($rows >=1){
                    // redirect success page
          $this->mViewData['invno'] = $invno;

          $this->render('success_payment');
     
        }
      else{
         // Display failure message
        $this->session->set_flashdata('flashError', 'M-pesa Code Not Found In Our Databases, Please try again.');

        redirect('mpesa/c2b/'.$invno);
    }
  }
  
   public function pdfinvoice($id) {
        $this->load->library('Pdf');
        $data['id'] = $id;
        $this->load->view('pdfinvoice', $data);
    }
    
    
    public function stkpush() {
        $id = $this->input->post('id');
        $phoneno = $this->input->post('phone');
        $query = $this->db->get_where('invoices', array('invoice_number' => $id));
        $tenantid = $query->row('tenant_id');
        $amount = $query->row('balance');
        $code = 254;
        $mpesaphone = $code . "" . $phoneno . "";
        date_default_timezone_set('Africa/Nairobi');
        # access token
        $consumerKey = 'ng6WcUztGeN5oGckG8EyyGJGKaJl3jaU';  //$cKey; //Fill with your app Consumer Key
        $consumerSecret = '8KIGAzduMdS95GhZ';   //$sKey; // Fill with your app Secret
        $BusinessShortCode = 7835188;
        $Passkey = 'b400cdd7038c7550e047f45176ffb6419e5414824a565e692c9cd6ee248489c7';
        $PartyA = $mpesaphone; // This is your phone number,
        $AccountReference = '7835188';
        $TransactionDesc = 'Invoice Payment';
        # Get the timestamp, format YYYYmmddhms -> 20181004151020
        $Timestamp = date('YmdHis');
        
        # Get the base64 encoded string -> $password. The passkey is the M-PESA Public Key
        $Password = base64_encode($BusinessShortCode.$Passkey.$Timestamp);
        
 
        # header for access token
        $headers = ['Content-Type:application/json; charset=utf8'];

         
        # M-PESA endpoint urls
        $access_token_url = 'https://api.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials';
        $initiate_url = 'https://api.safaricom.co.ke/mpesa/stkpush/v1/processrequest';
        
        # callback url
          $CallBackURL = 'https://portal.geomarahomes.co.ke/mpesa/callBackUrl';
  
          $curl = curl_init($access_token_url);
          curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
          curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
          curl_setopt($curl, CURLOPT_HEADER, FALSE);
          curl_setopt($curl, CURLOPT_USERPWD, $consumerKey.':'.$consumerSecret);
          $result = curl_exec($curl);
          $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
          $result = json_decode($result);
          $access_token = $result->access_token;  
          curl_close($curl);
           
      
       # header for stk push
       $stkheader = ['Content-Type:application/json','Authorization:Bearer ' . $access_token];

        
        # initiating the transaction
        
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $initiate_url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $stkheader); 
        
        
        //setting custom header
        $curl_post_data = array(
        //Fill in the request parameters with valid values
        'BusinessShortCode' => $BusinessShortCode, 
        'Password' => $Password, 
        'Timestamp' => $Timestamp, 
        'TransactionType' => 'CustomerBuyGoodsOnline', 
        'Amount' => intval($amount), 
        'PartyA' => $PartyA, 
        'PartyB' => '9751979', 
        'PhoneNumber' => $PartyA, 
        'CallBackURL' => $CallBackURL, 
        'AccountReference' => $AccountReference, 
        'TransactionDesc' => $TransactionDesc);
        $data_string = json_encode($curl_post_data);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);
        $curl_response = curl_exec($curl);
        //echo $curl_response;
        $response = json_decode($curl_response);
        


        if($response->ResponseCode !=0){
            // Display failure  message
           $this->session->set_flashdata('flashError', 'Payment Initiated Failed, Please try again.');
           redirect('home/payinvoice/'.$id);
     
        } else {
            $data = array('CheckoutRequestID' => $response->CheckoutRequestID, 
                          'invoice_id' => $id, 
                          'status' => 1);
            $this->db->insert('mpesarequests', $data);
            $this->session->set_flashdata('flashSuccess', 'Please wait to enter MPESA PIN when prompted');
           redirect('home/payinvoice/'.$id);
             $this->mViewData['invno'] = $id;
             $this->render('success_payment');
        }
      
      
    }
    
    
    public function callBackUrl(){
        header("Content-Type: application/json");
        
        $mpesaResponse = file_get_contents('php://input');
     
         // log the response
         $logFile = "M_PESAConfirmationResponse.txt";
     
         // write to file
         $log = fopen($logFile, "a");
     
         fwrite($log, $mpesaResponse);
         fclose($log);
     
         $json = file_get_contents('https://portal.geomarahomes.co.ke/M_PESAConfirmationResponse.txt');

         $response = json_decode($json);
         $resCode = $response->Body->stkCallback->ResultCode;
          
           if($resCode ==0){
                    $resData = $response->Body->stkCallback->CallbackMetadata;
                    $MerchantRequestID = $response->Body->stkCallback->MerchantRequestID;
                    $CheckoutRequestID = $response->Body->stkCallback->CheckoutRequestID;
                    $amount_paid = $resData->Item[0]->Value;
                    $mpesa_receipt_no = $resData->Item[1]->Value;
                    $phone = $resData->Item[4]->Value;
                    

                $data = array(
                    'status' => '0',
                    'amount' => $amount_paid,
                    'mpesa_receipt_no' => $mpesa_receipt_no,
                    'phone' => $phone,
                    );
                    
                    $this->db->where('CheckoutRequestID', $CheckoutRequestID);
                    $this->db->update('mpesarequests', $data);
                  
                            //update query
        }
        
        $f = @fopen("M_PESAConfirmationResponse.txt", "r+");
        if ($f !== false) {
            
            ftruncate($f, 0);
            fclose($f);
        }
          
        $this->mpesa_reconcile();

    }
    
    public function mpesa_reconcile() {
        $query = $this->db->get_where('mpesarequests', array('reconciled' => 0));
        
        foreach ($query->result() as $row) {
            $invid = $row->invoice_id;
            $amount = $row->amount;
            $amount_paid = $amount;
            $ref = $row->mpesa_receipt_no;
            $id = $row->id;
            $CheckoutRequestID = $row->CheckoutRequestID;
            $phone = $row->phone;
            
           //update reconciled mpesa requests
            $data = array('reconciled' => 1,);
            $this->db->where('id', $id);
            $this->db->update('mpesarequests', $data);
            
            //Get SMS Settings
            $query = $this->db->get('sms_settings');
            $apiusername = $query->row('api_username');
            $apisenderid = $query->row('api_sender_id');
            $api_key = $query->row('api_key');
            //Send an SMS response to the Customer
            $username = $apiusername;
            $apikey = $api_key;
            $recipients = $phone;
            $message = "Your payment of " . $amount_paid . " be payment for rent has been received successfuly. Thanks.";
            $from = $apisenderid;
            // Create a new instance of our awesome gateway class
            $gateway = new AfricasTalkingGateway($username, $apikey);
            $results = $gateway->sendMessage($recipients, $message, $from);
            
            //update invoice paid and balance
            $query = $this->db->get_where('invoices', array('invoice_number' => $invid));
            foreach ($query->result() as $row) {
                $paid = $row->paid;
                $balance = $row->balance;
                $propertyid = $row->property_id;
                $tenantid = $row->tenant_id;
                $month = $row->month;
                $year = $row->year;
                $id = $row->id;
                $newpaid = intval($paid) + intval($amount_paid);
                $newbalance = intval($balance) - intval($amount_paid);
                if ($newbalance <= 0) {
                    $status = 'Paid';
                }
                if ($newbalance > 0) {
                    $status = 'Partial';
                }
                $data = array('paid' => $newpaid, 
                              'balance' => $newbalance, 
                              'status' => $status,);
                $this->db->where('id', $id);
                $this->db->update('invoices', $data);
            }
            
            $this->db->where('invoice_number', $invid);
            $this->db->from('invoiceitems');
            $query = $this->db->get();
            foreach ($query->result() as $row) {
                $invoiceid = $row->id;
                $propertyid = $row->property_id;
                $tax_status = $row->tax_status;
                $invoice_amount = $row->balance;
                $commisionable = $row->Commisionable;
                $paid = $row->paid;
                $year = $row->year;
                $month = $row->month;
                 //Retrieve Property Data
                $query = $this->db->get_where('property', array('id' => $propertyid));
                foreach ($query->result() as $row) {
                    $landlordid = $row->landlord_id;
                    $rate = $row->commission;
                }
                if ($invoice_amount > $amount_paid) {
                $newbalance = intval($invoice_amount) - intval($amount_paid);
                $newpaid = intval($paid) + intval($amount_paid);
                $status = 'Partial';
                } else if ($invoice_amount < $amount_paid) {
                    $newbalance = 0.00;
                    $newpaid = intval($paid) + intval($invoice_amount);
                    $status = 'Paid';
                    
                } else if ($invoice_amount == $amount_paid) {
                    $newbalance = 0.00;
                    $newpaid = intval($invoice_amount) + intval($paid);
                    $status = 'Paid';
                    
                }
                if ($commisionable == 'No'){
                    $commission = 0;
                }else if ($commisionable == 'Yes') {
                    $commission = intval($rate)/intval(100) * intval($newpaid);
                }
                if ($tax_status == 'Taxable') {
                    $vat = 16 / 100 * intval($commission);
                }
                
                $landlord_amount = intval($newpaid) - intval($commission);
                $data = array('paid' => $newpaid, 
                              'balance' => $newbalance, 
                              'status' => $status,
                              );
                $this->db->where('id', $invoiceid);
                $this->db->update('invoiceitems', $data);
                
                //insert mpesa payment to invoicepayments
                $data = array('invoiceid' => $invid, 
                                  'amount_paid' => $invoice_amount, 
                                  'refno' => $invid, 
                                  'landlordid' => $landlordid,
                                  'mpesa_receipt_no' => $ref, 
                                  'method' => 'MPESA', 
                                  'month' => $month, 
                                  'year' => $year, 
                                  'propertyid' => $propertyid, 
                                  'tenantid' => $tenantid, 
                                  'recordcreator' => 'System', 
                                  'CheckoutRequestID' => $CheckoutRequestID, 
                                  );
                                  
                    $this->db->insert('invoicepayments', $data);
            }
            
            
        }
        
    }
    
    public function testsms (){
        
         $query = $this->db->get_where('mpesarequests', array('reconciled' => 0));
        
        foreach ($query->result() as $row) {
         
            $phone = $row->phone;
        }
           
          
            //Get SMS Settings
            $query = $this->db->get('sms_settings');
            $apiusername = $query->row('api_username');
            $apisenderid = $query->row('api_sender_id');
            $api_key = $query->row('api_key');
            //Send an SMS response to the Customer
            $username = $apiusername;
            $apikey = $api_key;
            $recipients = $phone;
            $message = "Your payment of " . 900 . " be payment for rent has been received successfuly. Thanks.";
            $from = $apisenderid;
            // Create a new instance of our awesome gateway class
            $gateway = new AfricasTalkingGateway($username, $apikey);
            $results = $gateway->sendMessage($recipients, $message, $from);
            
            
    }
    
    
}












