<?php

defined('BASEPATH') OR exit('No direct script access allowed');

$config['ci_bootstrap'] = array(
    // Site name
    'site_name' => 'Clinic Manager',
    // Default page title prefix
    'site_name' => 'Clinic Manager',
    'page_title_prefix' => 'Clinic Manager - ',
    // Default page title
     'page_title' => '',
    // Default meta data
    'meta_data' => array(
        'author' => 'Geoffrey Kyalo',
        // 'description' => 'GEOMARA HOMES Real Estate Management System',
        // 'keywords' => 'GEOMARA HOMES Real Estate Management System'
    ),
    // Default scripts to embed at page head or end
    'scripts' => array(
        'head' => array(
           // 'assets/dist/admin/lib.min.js',
           // 'assets/dist/admin/app.min.js',
          'assets/dist/admin/plugins/jquery/jquery.min.js',

          ),
          
          
        'foot' => array(
          
        'assets/dist/admin/plugins/bootstrap/js/bootstrap.bundle.min.js',
        'assets/dist/admin/adminlte.js',
        'assets/js/jquery.validate.js',
        'assets/js/validation.js',
        'assets/dist/admin/plugins/moment/moment.min.js',
        'assets/dist/admin/plugins/datatables/jquery.dataTables.min.js',
        'assets/dist/admin/plugins/select2/js/select2.full.min.js',
        'assets/dist/admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js',
        'assets/dist/admin/plugins/datatables-responsive/js/dataTables.responsive.min.js',
        'assets/dist/admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js',
        'assets/dist/admin/plugins/datatables-buttons/js/dataTables.buttons.min.js',
        'assets/dist/admin/plugins/datatables-buttons/js/buttons.bootstrap4.min.js',
        'assets/dist/admin/plugins/jszip/jszip.min.js',
        'assets/dist/admin/plugins/pdfmake/pdfmake.min.js',
        'assets/dist/admin/plugins/pdfmake/vfs_fonts.js',
        'assets/dist/admin/plugins/datatables-buttons/js/buttons.html5.min.js',
        'assets/dist/admin/plugins/datatables-buttons/js/buttons.print.min.js',
        'assets/dist/admin/plugins/datatables-buttons/js/buttons.colVis.min.js',
        'assets/dist/admin/plugins/daterangepicker/daterangepicker.js',
        'assets/dist/admin/plugins/sweetalert2/sweetalert2.all.js',
        'assets/dist/admin/plugins/sweetalert2/sweetalert2.all.min.js',
        'assets/dist/admin/plugins/sweetalert2/sweetalert2.min.js',
                 
        ),
    ),
    // Default stylesheets to embed at page head
    'stylesheets' => array(
        'screen' => array(
            'assets/dist/admin/adminlte.css',
            'https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback',
            'assets/dist/admin/plugins/fontawesome-free/css/all.min.css',
            'https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css',
            'assets/dist/admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css',
            'assets/dist/admin/plugins/datatables-responsive/css/responsive.bootstrap4.min.css',
            'assets/dist/admin/plugins/datatables-buttons/css/buttons.bootstrap4.min.css',
            'assets/dist/admin/plugins/select2/css/select2.min.css',
            'assets/dist/admin/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css',
            'assets/dist/admin/plugins/dropzone/min/dropzone.min.css',
            'assets/dist/admin/plugins/daterangepicker/daterangepicker.css',
            'assets/dist/admin/plugins/sweetalert2/sweetalert2.css',
            'assets/dist/admin/plugins/sweetalert2/sweetalert2.min.css',

          )
    ),
    // Default CSS class for <body> tag
    'body_class' => 'skin-blue',
    // Multilingual settings
    'languages' => array(
    ),
    // Menu items
    'menu' => array(
        'dashboard' => array(
            'name' => 'Dashboard',
            'url' => '',
            'icon' => 'fa fa-home',
        ),
        'Reception' => array(
            'name' => 'Reception',
            'url' => 'patients',
            'icon' => 'fa fa-book',

            'children' => array (
                'Add Patient' => 'patients/add',
                'All Patients' =>'patients',
                'Queues' => 'patients/queue_list',
                // 'List Appointment' => 'appointment',
                // 'Add Appointment' =>'appointment/add',
            )
        ),
        
        'Triage' => array(
            'name' => 'Triage',
            'url' => 'tenants',
            'icon' => 'fa fa-stethoscope ',
            
            'children' => array (
                'Queues' =>'triage',
                'Patient Record' => 'triage/list',
            )
        ),
      
        'Consultation' => array(
            'name' => 'Doctor',
            'url' => 'subscriptions',
            'icon' => 'fa fa-user-md ',
            
             'children' => array (
                'Queue' =>'consultation',
                'Patient Records' => 'consultation/list',
                'Lab Results' => 'consultation/results',
                'Diagnosis'  => 'consultation/diagnosis',
             )
        ),
        
  
               
        'Laboratory' => array(
            'name' => 'Laboratory',
            'url' => 'invoices',
            'icon' => 'fa fa-flask ',
            'children' => array(
                 'Queue' => 'laboratory',
                 'Patient Records' => 'laboratory/list',
                 'Lab Tests'  => 'Laboratory/tests',
            )
        ),
        
        'Prescription' => array(
            'name' => 'Pharmacy',
            'url' => 'invoices',
            'icon' => 'fa fa-plus-square',
            'children' => array(
                 'Prescriptions' => 'prescription',
                 'Pharmacy Records' => 'prescription/list',
            )
        ),
        'reports' => array(
            'name' => 'Reports',
            'url' => 'reports',
            'icon' => 'fa fa-file',
 
 
            'children' => array(
                'Daily Visits' => 'reports',
                'Diagnosis Report' => 'reports/diagnosis',
                'Laboratory Report' => 'reports/lab_report',
                'Monthly Analysis' => 'home/vouchersfilter',
            )
        ),


        'panel' => array(
            'name' => 'Settings',
            'url' => 'panel',
            'icon' => 'fa fa-cog ',
            'children' => array(
                'System Setup' => 'panel/settings',
                'Roles' => 'roles',
                'Users Accounts' => 'panel/admin_user',
                'Create User Account' => 'panel/admin_user_create',
                
                
            )
        ),
        
        
        'util' => array(
            'name' => 'Backup',
            'url' => 'util/list_db',
            'icon' => 'fa fa-cogs',
        ),


        
        'logout' => array(
            'name' => 'Sign Out',
            'url' => 'panel/logout',
            'icon' => 'fa fa-sign-out ',
        )
    ),
    // Login page
    'login_url' => 'admin/login',
    // Restricted pages
    'page_auth' => array(
        
        //patients
        'patients/add' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        'patients' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        'patients/queue_list' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        'patients/queue' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        'patients/edit' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
       
        //Triage
        'triage' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        'triage/list' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),

        //Doctor
        'consultation' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        'consultation/list' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        'consultation/results' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        
      //Prescription
        'prescription' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        'prescription/add' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
 
       //Laboratory
        'laboratory' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
        
       //reports
        'reports' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),

       //Billing
        'billing' => array('webmaster', 'Administrators', 'Doctor','Front_Office','Clinician','Lab Technician'),
       
       //Admin
        'user/create' => array('webmaster', 'Administrators'),
        'user/group' => array('webmaster', 'Administrators'),
        'panel' => array('webmaster', 'Administrators'),
        'panel/admin_user' => array('webmaster', 'Administrators'),
        'panel/admin_user_create' => array('webmaster'),
        'panel/admin_user_group' => array('webmaster', 'Administrators'),
       
        'util' => array('webmaster'),
        'util/list_db' => array('webmaster'),
        'util/backup_db' => array('webmaster'),
        'util/restore_db' => array('webmaster'),
        'util/remove_db' => array('webmaster'),
    ),

    // AdminLTE settings
    'adminlte' => array(
        'body_class' => array(
            'webmaster' => 'skin-blue',
            'Administrators' => 'skin-blue',
            'Doctor' => 'skin-blue',
            'Lab Technician' => 'skin-blue',
            'Clinician'=> 'skin-blue',
            'Front_Office'=> 'skin-blue',
        )
    ),
    // Useful links to display at bottom of sidemenu
    'useful_links' => array(
    /* array(
      'auth'    => array('webmaster', 'admin', 'manager', 'staff'),
      'name'    => 'Frontend Website',
      'url'   => '',
      'target'  => '_blank',
      'color'   => 'text-aqua'
      ), */
    ),
    // Debug tools
    'debug' => array(
        'view_data' => FALSE,
        'profiler' => FALSE
    ),
);

/*
  | -------------------------------------------------------------------------
  | Override values from /application/config/config.php
  | -------------------------------------------------------------------------
 */
$config['sess_cookie_name'] = 'ci_session_admin';


