<?php
    defined('BASEPATH') OR exit('No direct script access allowed');
    class Triage extends Admin_Controller {
        public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->library('excel');
        $this->load->model('patients_model');
        $this->load->model('queue_model');
        $this->load->model('triage_model');
        $this->load->model('tests_model');
    }
    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['triage'] = $this->queue_model->get_by_department('Triage');
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
        if (strpos($sql->row('rights'), "Access Triage") !== false) {
            $this->render('Triage/index');
        } else {
            $this->render('errors/custom/access');
        }
    }
    
    public function add($id){
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['triage'] = $this->queue_model->get_by_id($id);
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
        if (strpos($sql->row('rights'), "Add Triage Record") !== false) {
            $this->render('Triage/add');
        } else {
            $this->render('errors/custom/access');
        }
    }
    
    public function edit($id){
         $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['id'] =$id;
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['triage'] = $this->triage_model->get_by_id($id);
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
        if (strpos($sql->row('rights'), "Update Triage Details") !== false) {
            $this->render('Triage/edit');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function view($id){
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['triage'] = $this->triage_model->get_by_id($id);
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
        if (strpos($sql->row('rights'), "View Triage Record") !== false) {
            $this->render('Triage/view');
        } else {
            $this->render('errors/custom/access');
        }
    }
    
    public function list(){
        $date = date('Y-m-d');
        
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['records'] = $this->triage_model->get_daily_patients($date);
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
        if (strpos($sql->row('rights'), "Access Triage") !== false) {
            $this->render('Triage/list');
        } else {
            $this->render('errors/custom/access');
        }
    }
    
     public function queue($id) {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['patient'] = $this->patients_model->get_by_id($id);
        $this->mViewData['tests'] = $this->tests_model->get_all();
        $this->render('Triage/queue');
    }

    public function search(){
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $date = explode('-', $this->input->post('daterange'));
        $startdate = str_replace('/','-',str_replace(" ", "", $date[0]));
        $enddate = str_replace('/','-',str_replace(" ", "", $date[1]));
        $this->db->where('date >=', $startdate);
        $this->db->where('date <=', $enddate);
        $sql = $this->db->get('triage');
        $response = $sql->result();
        $this->mViewData['records'] = $response; //$this->triage_model->get_date_range($startdate,$enddate);
        $this->render('Triage/list');
    }
    
    public function save(){
            //Logged In User Session
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $date = date('Y-m-d');
            
             //Validation
            $this->load->helper(array('form', 'url'));
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('', '');
            $this->form_validation->set_rules('id', 'Patient Name', 'required');
            $this->form_validation->set_rules('mode_of_arrival', 'Mode of Arrival', 'required');
            $this->form_validation->set_rules('triage_level', 'Triage Level', 'required');
            $this->form_validation->set_rules('blood_pressure', 'Blood Pressure', 'required');
            $this->form_validation->set_rules('temperature', 'Temperature', 'required');
            if ($this->form_validation->run() == FALSE) {
                echo validation_errors();
            } else {
            $q_id = $this->input->post('q_id');
            $patient_id = $this->input->post('id');
            $arrival = $this->input->post('mode_of_arrival');
            $triage_level = $this->input->post('triage_level');
            $blood_pressure = $this->input->post('blood_pressure');
            $temperature = $this->input->post('temperature');
            $height = $this->input->post('height');
            $weight = $this->input->post('weight');
            $pr = $this->input->post('pr');
            $rr = $this->input->post('rr');
            $spo = $this->input->post('spo');
            $rbs = $this->input->post('rbs');
            $action = $this->input->post('action');
            //Gen File No.
            $sql = $this->db->get_where('visits', array('patient_id'=>$patient_id, 'date'=>$date));
            $visit_id = $sql->row('visit_id');

            $data = array (
                'visit_id' => $visit_id,
                'patient_id' => $patient_id,
                'mode_of_arrival' => $arrival,
                'triage_level' => $triage_level,
                'blood_pressure' => $blood_pressure,
                'temperature' => $temperature,
                'height_weight' => $height,
                'weight' => $weight,
                'pr' => $pr,
                'rr' => $rr,
                'spo' => $spo,
                'rbs' => $rbs,
                'date' => $date,
                'record_creator' => $username,
                );
             //Save Data
             $res = $this->triage_model->save($data);
             if ($res == true) {
                 //UPDATE Q
                 $data = array (
                     'status' => 'Attended',
                     );
                     $this->db->where('id', $q_id);
                     $this->db->update('queues', $data);
                     if ($action == 'queue') {
                        redirect('admin/triage/queue/'.$patient_id);
                     } else {
                        $this->session->set_flashdata('success', "Record added Successfully");
                        redirect('admin/triage/list');
                     }
                } else {
                    $this->session->set_flashdata('error', "Record Not Inserted");
                    redirect('admin/triage/list');
                }
            }
        }

    public function update(){
             //Logged In User Session
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $date = date('Y-m-d');
            //Triage Information
            $id = $this->input->post('id');
            $arrival = $this->input->post('mode_of_arrival');
            $triage_level = $this->input->post('triage_level');
            $blood_pressure = $this->input->post('blood_pressure');
            $temperature = $this->input->post('temperature');
            $height = $this->input->post('height');
            $weight = $this->input->post('weight');
            $pr = $this->input->post('pr');
            $rr = $this->input->post('rr');
            $spo = $this->input->post('spo');
            $rbs = $this->input->post('rbs');

             $data = array (
                'mode_of_arrival' => $arrival,
                'triage_level' => $triage_level,
                'blood_pressure' => $blood_pressure,
                'temperature' => $temperature,
                'height_weight' => $height,
                'weight' => $weight,
                'pr' => $pr,
                'rr' => $rr,
                'spo' => $spo,
                'rbs' => $rbs,
                );

            $this->db->where('id', $id);
            $res = $this->db->update('triage', $data);

            if ($res == true) {
                $this->session->set_flashdata('success', "Record added Successfully");
                redirect('admin/triage/list');
            } else {
                $this->session->set_flashdata('error', "Record Not Inserted");
                redirect('admin/triage/list');
            }
        }

     public function delete($id) {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
        if (strpos($sql->row('rights'), "Delete Triage Record ") !== false) {
            $this->triage_model->delete_by_id($id);
            echo json_encode(array("status" => TRUE));
        } else {
            echo json_encode(array("status" => TRUE));
        }
    }
    
}