<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Units_model extends CI_Model {

    var $table = 'units';

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function get_all_units() {
        $this->db->from('units');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_by_id($id) {
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();

        return $query->row();
    }

    public function get_units($propertyid) {
        
        $this->db->where('status', 'Vacant');
        $this->db->from($this->table);
        $this->db->where('property_id', $propertyid);
        $query = $this->db->get();

        foreach ($query->result_array() as $row) {
            $result[] = $row['unit_code'];
        }
        return $result;
    }

    public function unit_add($data) {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

    public function unit_update($where, $data) {
        $this->db->update($this->table, $data, $where);
        return $this->db->affected_rows();
    }

    public function delete_by_id($id) {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

}
