#
# TABLE STRUCTURE FOR: admin_groups
#

DROP TABLE IF EXISTS `admin_groups`;

CREATE TABLE `admin_groups` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('1', 'webmaster', '<ul>\r\n	<li>Maintain websites and web applications for clients and businesses.</li>\r\n	<li>Ensure the web servers, hardware and software are operating accurately.</li>\r\n</ul>\r\n');
INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('2', 'Administrators', '<p>Administrator</p>\n');
INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('3', 'Accounting', '<p>The <strong>accounting department</strong> is responsible for recording and reporting the cash flow transactions of a company. This <strong>department</strong> has some key <strong>roles</strong> and responsibilities, including <strong>accounts</strong> receivable, <strong>accounts</strong> payable, payroll, financial reporting, and maintaining financial controls.</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('4', 'Managers', '');
INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('5', 'Front_Office', '');


#
# TABLE STRUCTURE FOR: admin_login_attempts
#

DROP TABLE IF EXISTS `admin_login_attempts`;

CREATE TABLE `admin_login_attempts` (
  `id` int(11) unsigned NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: admin_users
#

DROP TABLE IF EXISTS `admin_users`;

CREATE TABLE `admin_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(15) NOT NULL,
  `username` varchar(100) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `activation_code` varchar(40) DEFAULT NULL,
  `forgotten_password_code` varchar(40) DEFAULT NULL,
  `forgotten_password_time` int(11) unsigned DEFAULT NULL,
  `remember_code` varchar(40) DEFAULT NULL,
  `created_on` int(11) unsigned NOT NULL,
  `last_login` int(11) unsigned DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `Id_No` int(255) NOT NULL,
  `Phone_No` int(255) NOT NULL,
  `Image` varchar(255) NOT NULL,
  `office` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `admin_users` (`id`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `Id_No`, `Phone_No`, `Image`, `office`) VALUES ('1', '127.0.0.1', 'webmaster', '$2y$08$QRcA9nuZh/5e.e0hfHeYN.zKfyZuUeBbgmE/aWDsjgsVMG1GXY5C.', NULL, 'mwaspython@gmail.com', NULL, NULL, NULL, 'epB3mYDI2/S26JkinD/.y.', '1451900190', '1657014982', '1', 'Joel', 'Mwangi', '0', '2147483647', '397ef-property.jpg', '');
INSERT INTO `admin_users` (`id`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `Id_No`, `Phone_No`, `Image`, `office`) VALUES ('2', '127.0.0.1', 'Geomara', '$2y$08$aGEUipNTjzBpbzQLvlkHT.gDMdveBfjqd39q85EfZ36JqN4elclQC', NULL, NULL, NULL, NULL, NULL, NULL, '1610449780', NULL, '1', 'Mara', '', '0', '0', '49528-property.jpg', '1 ');
INSERT INTO `admin_users` (`id`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `Id_No`, `Phone_No`, `Image`, `office`) VALUES ('3', '105.163.0.42', 'Jeff', '$2y$08$jPnmljEWfQe3B6pRJoTeieao1KxDPw/TOBHhTQll6NHjlUNvXYPU.', NULL, NULL, NULL, NULL, NULL, NULL, '1656392932', '1656392963', '1', 'Geoffrey', 'Kyalo', '0', '0', '49528-property.jpg', '1 ');
INSERT INTO `admin_users` (`id`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `Id_No`, `Phone_No`, `Image`, `office`) VALUES ('4', '102.140.192.222', 'accountant', '$2y$08$c5WUMlf08MdQAQV3OdgVz.n3cvkU0kb5br.1WYDYIRYQBOblW5sbu', NULL, NULL, NULL, NULL, NULL, NULL, '1656607562', '1656609586', '1', 'Accounts', 'Mwangi', '0', '0', '49528-property.jpg', '1 ');
INSERT INTO `admin_users` (`id`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `Id_No`, `Phone_No`, `Image`, `office`) VALUES ('5', '102.140.192.222', 'frontoffice', '$2y$08$0LtVB.Gb8yjnYl2anZpfeeTGmpoO7OBuv3xn2L78jcj.mSOxzp6ga', NULL, NULL, NULL, NULL, NULL, NULL, '1656656230', '1656656265', '1', 'Office', 'FO', '0', '0', '49528-property.jpg', '1 ');


#
# TABLE STRUCTURE FOR: admin_users_groups
#

DROP TABLE IF EXISTS `admin_users_groups`;

CREATE TABLE `admin_users_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `group_id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;

INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('1', '1', '1');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('7', '3', '3');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('20', '12', '2');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('27', '13', '4');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('28', '14', '5');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('29', '2', '2');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('30', '0', '5');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('31', '0', '5');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('32', '0', '5');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('33', '0', '5');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('34', '3', '2');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('35', '4', '3');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('36', '5', '5');


#
# TABLE STRUCTURE FOR: advance
#

DROP TABLE IF EXISTS `advance`;

CREATE TABLE `advance` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `employee` varchar(255) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `month` varchar(255) NOT NULL,
  `year` year(4) NOT NULL,
  `date` date NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `paymentmethod` varchar(255) NOT NULL,
  `paymentref` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: api_access
#

DROP TABLE IF EXISTS `api_access`;

CREATE TABLE `api_access` (
  `id` int(11) unsigned NOT NULL,
  `key` varchar(40) NOT NULL DEFAULT '',
  `controller` varchar(50) NOT NULL DEFAULT '',
  `date_created` datetime DEFAULT NULL,
  `date_modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: api_keys
#

DROP TABLE IF EXISTS `api_keys`;

CREATE TABLE `api_keys` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `key` varchar(40) NOT NULL,
  `level` int(2) NOT NULL,
  `ignore_limits` tinyint(1) NOT NULL DEFAULT 0,
  `is_private_key` tinyint(1) NOT NULL DEFAULT 0,
  `ip_addresses` text DEFAULT NULL,
  `date_created` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `api_keys` (`id`, `user_id`, `key`, `level`, `ignore_limits`, `is_private_key`, `ip_addresses`, `date_created`) VALUES ('1', '0', 'anonymous', '1', '1', '0', NULL, '1463388382');
INSERT INTO `api_keys` (`id`, `user_id`, `key`, `level`, `ignore_limits`, `is_private_key`, `ip_addresses`, `date_created`) VALUES ('1', '0', 'anonymous', '1', '1', '0', NULL, '1463388382');


#
# TABLE STRUCTURE FOR: api_limits
#

DROP TABLE IF EXISTS `api_limits`;

CREATE TABLE `api_limits` (
  `id` int(11) NOT NULL,
  `uri` varchar(255) NOT NULL,
  `count` int(10) NOT NULL,
  `hour_started` int(11) NOT NULL,
  `api_key` varchar(40) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: api_logs
#

DROP TABLE IF EXISTS `api_logs`;

CREATE TABLE `api_logs` (
  `id` int(11) NOT NULL,
  `uri` varchar(255) NOT NULL,
  `method` varchar(6) NOT NULL,
  `params` text DEFAULT NULL,
  `api_key` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `time` int(11) NOT NULL,
  `rtime` float DEFAULT NULL,
  `authorized` varchar(1) NOT NULL,
  `response_code` smallint(3) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expenditures
#

DROP TABLE IF EXISTS `expenditures`;

CREATE TABLE `expenditures` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `officeid` int(50) NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `vat` decimal(25,2) NOT NULL,
  `paidto` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `refno` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: expense_category
#

DROP TABLE IF EXISTS `expense_category`;

CREATE TABLE `expense_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO `expense_category` (`id`, `name`, `description`) VALUES ('3', 'Transport', 'tra');
INSERT INTO `expense_category` (`id`, `name`, `description`) VALUES ('5', 'Cleaning', ' cleon');
INSERT INTO `expense_category` (`id`, `name`, `description`) VALUES ('6', 'Maintainance', 'General Repairs');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `propertyid` varchar(50) DEFAULT NULL,
  `amount` decimal(25,2) DEFAULT NULL,
  `vat` int(255) DEFAULT NULL,
  `paidto` varchar(50) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `refno` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: guest
#

DROP TABLE IF EXISTS `guest`;

CREATE TABLE `guest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `property_id` int(11) NOT NULL,
  `unit_id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `idno` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `check_in` varchar(255) NOT NULL,
  `check_out` varchar(255) NOT NULL,
  `rate` decimal(10,2) NOT NULL DEFAULT 0.00,
  `no_of_days` int(11) NOT NULL,
  `total_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` varchar(255) NOT NULL,
  `record_creator` varchar(255) NOT NULL,
  `record_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `guest` (`id`, `property_id`, `unit_id`, `name`, `phone`, `idno`, `email`, `check_in`, `check_out`, `rate`, `no_of_days`, `total_amount`, `status`, `record_creator`, `record_created`) VALUES ('1', '1', '6', 'Geoffrey Kyalo', '0701842081', '29242767', 'Geofreykyalo@Gmail.Com', '2022-05-18', '2022-05-21', '3500.00', '3', '10500.00', 'Checked Out', 'webmaster', '2022-05-18 15:25:17');
INSERT INTO `guest` (`id`, `property_id`, `unit_id`, `name`, `phone`, `idno`, `email`, `check_in`, `check_out`, `rate`, `no_of_days`, `total_amount`, `status`, `record_creator`, `record_created`) VALUES ('2', '1', '6', 'Telly Njeri', '701842081', '43434354', 'Abc@Gmail.Com', '2022-05-19', '2022-05-20', '2500.00', '1', '2500.00', 'Checked Out', 'webmaster', '2022-05-19 13:07:16');


#
# TABLE STRUCTURE FOR: invoiceitems
#

DROP TABLE IF EXISTS `invoiceitems`;

CREATE TABLE `invoiceitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(255) DEFAULT NULL,
  `property_id` varchar(255) DEFAULT NULL,
  `unit_code` varchar(255) DEFAULT NULL,
  `tenant_id` varchar(255) DEFAULT NULL,
  `year` varchar(255) DEFAULT NULL,
  `month` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `amount` decimal(20,2) DEFAULT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `balance` decimal(20,2) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `tax_status` varchar(255) DEFAULT NULL,
  `invoice_type` varchar(255) NOT NULL,
  `Commisionable` varchar(255) DEFAULT NULL,
  `invoicedate` varchar(255) DEFAULT NULL,
  `refid` varchar(255) DEFAULT NULL,
  `landlord_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `commission` decimal(10,2) NOT NULL DEFAULT 0.00,
  `percentage` int(11) NOT NULL,
  `tax` decimal(10,2) NOT NULL DEFAULT 0.00,
  `record_created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `record_creator` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=latin1;

INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('1', '12G0140001', '2', 'G01', '40', '2022', 'June', 'Garbage', '50.00', '30.00', '20.00', 'Partial', NULL, 'Other', NULL, '2022-06-30', '2022062G0140', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('2', '11G021002', '1', 'G02', '1', '2022', 'July', 'Rent for July', '4100.00', NULL, '4100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022071G021', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('3', '11G032003', '1', 'G03', '2', '2022', 'July', 'Rent for July', '4100.00', NULL, '4100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022071G032', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('4', '11G043004', '1', 'G04', '3', '2022', 'July', 'Rent for July', '4600.00', '4600.00', '0.00', 'Paid', 'No', 'Rent', NULL, '2022-07-01', '2022071G043', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('5', '11G054005', '1', 'G05', '4', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022071G054', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('6', '11G065006', '1', 'G06', '5', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022071G065', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('7', '11G076007', '1', 'G07', '6', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022071G076', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('8', '11G087008', '1', 'G08', '7', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022071G087', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('9', '11G098009', '1', 'G09', '8', '2022', 'July', 'Rent for July', '6000.00', '6000.00', '0.00', 'Paid', 'No', 'Rent', NULL, '2022-07-01', '2022071G098', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('10', '111019010', '1', '101', '9', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '20220711019', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('11', '11G0110011', '1', 'G01', '10', '2022', 'July', 'Rent for July', '6000.00', NULL, '6000.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022071G0110', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('12', '1110211012', '1', '102', '11', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207110211', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('13', '1110312013', '1', '103', '12', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207110312', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('14', '1110413014', '1', '104', '13', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207110413', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('15', '1110514015', '1', '105', '14', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207110514', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('16', '1110615016', '1', '106', '15', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207110615', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('17', '1110716017', '1', '107', '16', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207110716', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('18', '1110817018', '1', '108', '17', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207110817', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('19', '1110918019', '1', '109', '18', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207110918', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('20', '1120119020', '1', '201', '19', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207120119', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('21', '1120220021', '1', '202', '20', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207120220', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('22', '1120321022', '1', '203', '21', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207120321', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('23', '1120422023', '1', '204', '22', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207120422', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('24', '1120523024', '1', '205', '23', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207120523', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('25', '1120624025', '1', '206', '24', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207120624', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('26', '1120725026', '1', '207', '25', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207120725', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('27', '1120826027', '1', '208', '26', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207120826', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('28', '1120927028', '1', '209', '27', '2022', 'July', 'Rent for July', '4600.00', NULL, '4600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207120927', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('29', '1130328029', '1', '303', '28', '2022', 'July', 'Rent for July', '6000.00', NULL, '6000.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207130328', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('30', '1130529030', '1', '305', '29', '2022', 'July', 'Rent for July', '5500.00', NULL, '5500.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207130529', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('31', '1130630031', '1', '306', '30', '2022', 'July', 'Rent for July', '12500.00', NULL, '12500.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207130630', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('32', '1140131032', '1', '401', '31', '2022', 'July', 'Rent for July', '12500.00', NULL, '12500.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207140131', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('33', '1140332033', '1', '403', '32', '2022', 'July', 'Rent for July', '12500.00', NULL, '12500.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207140332', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('34', '1140533034', '1', '405', '33', '2022', 'July', 'Rent for July', '6000.00', NULL, '6000.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207140533', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('35', '1140634035', '1', '406', '34', '2022', 'July', 'Rent for July', '10000.00', NULL, '10000.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207140634', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('36', '1150235036', '1', '502', '35', '2022', 'July', 'Rent for July', '10000.00', '10000.00', '0.00', 'Paid', 'No', 'Rent', NULL, '2022-07-01', '202207150235', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('37', '1150336037', '1', '503', '36', '2022', 'July', 'Rent for July', '6000.00', NULL, '6000.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207150336', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('38', '1150537038', '1', '505', '37', '2022', 'July', 'Rent for July', '5500.00', NULL, '5500.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207150537', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('39', '12G0039039', '2', 'G00', '39', '2022', 'July', 'Rent for July', '2600.00', NULL, '2600.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022072G0039', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('40', '12G0140040', '2', 'G01', '40', '2022', 'July', 'Rent for July', '5100.00', '5100.00', '0.00', 'Paid', 'No', 'Rent', NULL, '2022-07-01', '2022072G0140', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('41', '12G0241041', '2', 'G02', '41', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022072G0241', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('42', '12G0342042', '2', 'G03', '42', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022072G0342', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('43', '12G0443043', '2', 'G04', '43', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022072G0443', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('44', '12G0544044', '2', 'G05', '44', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022072G0544', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('45', '12G0645045', '2', 'G06', '45', '2022', 'July', 'Rent for July', '5100.00', '5100.00', '0.00', 'Paid', 'No', 'Rent', NULL, '2022-07-01', '2022072G0645', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('46', '12G0746046', '2', 'G07', '46', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022072G0746', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('47', '12G0847047', '2', 'G08', '47', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '2022072G0847', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('48', '1210148048', '2', '101', '48', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207210148', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('49', '1210249049', '2', '102', '49', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207210249', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('50', '1210350050', '2', '103', '50', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207210350', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('51', '1210451051', '2', '104', '51', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207210451', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('52', '1210552052', '2', '105', '52', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207210552', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('53', '1210653053', '2', '106', '53', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207210653', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('54', '1210854054', '2', '108', '54', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207210854', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('55', '1220155055', '2', '201', '55', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207220155', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('56', '1220256056', '2', '202', '56', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207220256', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('57', '1220357057', '2', '203', '57', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207220357', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('58', '1220458058', '2', '204', '58', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207220458', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('59', '1220559059', '2', '205', '59', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207220559', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('60', '1220660060', '2', '206', '60', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207220660', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('61', '1220761061', '2', '207', '61', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207220761', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('62', '1220862062', '2', '208', '62', '2022', 'July', 'Rent for July', '5100.00', '5100.00', '0.00', 'Paid', 'No', 'Rent', NULL, '2022-07-01', '202207220862', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('63', '1230163063', '2', '301', '63', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207230163', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('64', '1230264064', '2', '302', '64', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207230264', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('65', '1230365065', '2', '303', '65', '2022', 'July', 'Rent for July', '5100.00', '5100.00', '0.00', 'Paid', 'No', 'Rent', NULL, '2022-07-01', '202207230365', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('66', '1230466066', '2', '304', '66', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207230466', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('67', '1230567067', '2', '305', '67', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207230567', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('68', '1230668068', '2', '306', '68', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207230668', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('69', '1230769069', '2', '307', '69', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207230769', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('70', '1230870070', '2', '308', '70', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207230870', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('71', '1240171071', '2', '401', '71', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207240171', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('72', '1240272072', '2', '402', '72', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207240272', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('73', '1240373073', '2', '403', '73', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207240373', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('74', '1240474074', '2', '404', '74', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207240474', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('75', '1240575075', '2', '405', '75', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207240575', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('76', '1240676076', '2', '406', '76', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207240676', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('77', '1240777077', '2', '407', '77', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207240777', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('78', '1240878078', '2', '408', '78', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207240878', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('79', '1250179079', '2', '501', '79', '2022', 'July', 'Rent for July', '5100.00', NULL, '5100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207250179', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');
INSERT INTO `invoiceitems` (`id`, `invoice_number`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `description`, `amount`, `paid`, `balance`, `status`, `tax_status`, `invoice_type`, `Commisionable`, `invoicedate`, `refid`, `landlord_amount`, `commission`, `percentage`, `tax`, `record_created`, `record_creator`) VALUES ('80', '1250280080', '2', '502', '80', '2022', 'July', 'Rent for July', '8100.00', NULL, '8100.00', 'Due', 'No', 'Rent', NULL, '2022-07-01', '202207250280', '0.00', '0.00', '0', '0.00', '0000-00-00 00:00:00', '');


#
# TABLE STRUCTURE FOR: invoicepayments
#

DROP TABLE IF EXISTS `invoicepayments`;

CREATE TABLE `invoicepayments` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `month` varchar(50) DEFAULT NULL,
  `year` int(50) DEFAULT NULL,
  `landlordid` int(11) DEFAULT NULL,
  `propertyid` int(11) DEFAULT NULL,
  `tenantid` int(11) DEFAULT NULL,
  `invoiceid` varchar(255) DEFAULT NULL,
  `method` varchar(50) DEFAULT NULL,
  `amount_paid` decimal(25,2) NOT NULL DEFAULT 0.00,
  `CheckoutRequestID` text DEFAULT NULL,
  `mpesa_receipt_no` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `commission` decimal(25,2) DEFAULT 0.00,
  `vat` decimal(25,2) DEFAULT 0.00,
  `landlord_amount` decimal(25,2) DEFAULT 0.00,
  `refno` varchar(50) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `remittance_status` varchar(255) NOT NULL DEFAULT 'unremitted',
  `recordcreator` varchar(45) DEFAULT NULL,
  `recordcreated` timestamp NULL DEFAULT current_timestamp(),
  `reversaltime` int(100) DEFAULT NULL,
  `reversalreason` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=140748 DEFAULT CHARSET=latin1;

INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('2', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('3', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('4', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('5', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('6', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('7', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('8', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('9', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('10', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('11', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('12', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('13', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('14', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('15', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('16', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('17', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('18', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('19', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('20', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('21', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('22', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('23', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('24', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('25', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('26', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('27', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('28', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('29', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('30', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('31', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('32', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('33', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('34', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('35', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('36', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:03', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('37', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('38', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('39', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('40', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('41', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('42', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('43', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('44', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('45', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('46', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('47', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('48', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('49', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('50', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('51', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('52', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('53', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('54', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('55', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('56', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('57', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('58', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('59', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('60', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('61', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('62', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('63', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('64', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('65', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('66', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('67', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('68', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('69', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('70', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('71', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('72', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('73', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('74', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('75', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('76', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('77', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('78', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('79', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('80', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('81', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('82', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('83', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('84', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('85', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('86', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('87', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('88', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('89', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('90', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('91', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('92', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('93', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('94', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('95', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('96', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('97', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('98', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('99', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('100', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('101', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('102', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('103', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('104', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('105', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('106', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('107', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('108', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('109', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('110', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('111', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('112', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('113', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('114', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('115', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('116', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('117', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('118', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('119', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('120', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('121', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('122', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('123', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('124', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('125', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('126', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('127', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('128', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('129', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('130', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('131', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('132', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('133', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('134', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('135', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('136', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('137', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('138', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('139', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('140', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('141', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('142', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('143', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('144', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('145', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('146', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('147', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('148', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('149', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('150', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('151', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('152', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('153', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('154', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('155', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('156', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('157', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('158', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('159', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('160', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('161', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('162', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('163', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('164', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('165', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('166', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('167', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('168', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('169', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('170', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('171', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('172', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('173', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('174', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('175', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('176', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('177', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('178', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('179', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('180', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('181', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('182', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('183', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('184', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('185', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('186', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('187', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('188', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('189', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('190', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('191', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('192', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('193', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('194', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('195', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('196', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('197', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('198', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('199', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('200', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('201', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('202', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('203', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('204', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('205', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('206', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('207', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('208', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('209', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('210', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('211', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('212', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('213', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('214', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('215', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('216', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('217', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('218', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('219', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('220', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('221', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('222', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('223', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('224', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('225', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('226', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('227', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('228', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('229', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('230', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('231', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('232', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('233', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('234', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('235', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('236', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('237', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('238', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('239', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('240', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('241', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('242', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('243', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('244', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('245', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('246', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('247', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('248', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('249', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('250', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('251', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('252', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('253', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('254', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('255', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('256', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('257', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('258', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('259', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('260', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('261', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('262', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('263', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('264', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('265', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('266', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('267', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('268', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('269', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('270', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('271', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('272', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('273', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('274', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('275', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('276', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('277', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('278', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('279', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('280', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('281', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('282', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('283', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('284', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('285', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:04', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('286', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('287', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('288', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('289', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('290', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('291', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('292', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('293', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('294', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('295', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('296', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('297', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('298', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('299', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('300', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('301', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('302', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('303', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('304', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('305', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('306', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('307', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('308', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('309', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('310', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('311', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('312', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('313', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('314', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('315', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('316', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('317', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('318', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('319', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('320', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('321', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('322', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('323', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('324', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('325', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('326', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('327', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('328', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('329', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('330', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('331', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('332', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('333', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('334', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('335', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('336', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('337', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('338', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('339', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('340', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('341', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('342', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('343', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('344', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('345', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('346', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('347', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('348', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('349', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('350', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('351', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('352', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('353', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('354', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('355', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('356', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('357', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('358', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('359', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('360', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('361', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('362', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('363', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('364', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('365', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('366', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('367', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('368', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('369', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('370', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('371', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('372', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('373', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('374', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('375', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('376', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('377', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('378', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('379', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('380', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('381', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('382', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('383', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('384', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('385', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('386', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('387', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('388', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('389', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('390', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('391', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('392', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('393', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('394', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('395', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('396', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('397', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('398', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('399', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('400', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('401', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('402', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('403', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('404', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('405', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('406', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('407', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('408', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('409', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('410', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('411', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('412', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('413', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('414', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('415', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('416', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('417', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('418', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('419', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('420', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('421', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('422', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('423', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('424', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('425', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('426', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('427', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('428', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('429', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('430', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('431', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('432', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('433', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('434', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('435', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('436', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('437', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('438', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('439', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('440', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('441', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('442', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('443', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('444', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('445', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('446', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('447', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('448', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('449', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('450', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('451', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('452', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('453', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('454', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('455', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('456', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('457', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('458', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('459', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('460', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('461', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('462', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('463', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('464', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('465', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('466', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('467', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('468', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('469', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('470', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('471', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('472', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('473', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('474', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('475', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('476', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('477', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('478', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('479', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('480', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('481', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('482', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('483', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('484', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('485', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('486', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('487', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('488', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('489', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('490', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('491', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('492', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:05', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('493', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('494', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('495', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('496', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('497', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('498', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('499', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('500', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('501', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('502', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('503', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('504', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('505', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('506', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('507', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('508', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('509', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('510', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('511', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('512', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('513', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('514', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('515', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('516', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('517', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('518', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('519', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('520', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('521', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('522', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('523', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('524', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('525', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('526', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('527', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('528', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('529', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('530', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('531', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('532', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('533', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('534', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('535', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('536', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('537', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('538', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('539', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('540', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('541', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('542', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('543', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('544', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('545', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('546', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('547', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('548', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('549', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('550', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('551', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('552', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('553', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('554', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('555', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('556', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('557', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('558', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('559', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('560', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('561', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('562', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('563', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('564', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('565', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('566', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('567', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('568', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('569', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('570', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('571', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('572', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('573', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('574', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('575', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('576', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('577', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('578', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('579', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('580', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('581', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('582', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('583', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('584', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('585', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('586', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('587', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('588', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('589', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('590', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('591', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('592', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('593', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('594', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('595', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('596', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('597', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('598', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('599', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('600', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('601', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('602', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('603', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('604', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('605', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('606', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('607', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('608', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('609', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('610', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('611', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('612', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('613', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('614', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('615', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('616', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('617', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('618', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('619', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('620', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('621', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('622', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('623', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('624', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('625', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('626', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('627', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('628', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('629', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('630', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('631', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('632', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('633', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('634', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('635', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('636', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('637', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('638', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('639', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('640', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('641', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('642', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('643', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('644', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('645', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('646', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('647', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('648', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('649', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('650', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('651', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('652', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('653', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('654', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('655', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('656', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('657', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('658', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('659', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('660', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('661', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('662', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('663', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('664', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('665', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:06', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('666', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('667', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('668', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('669', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('670', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('671', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('672', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('673', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('674', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('675', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('676', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('677', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('678', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('679', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('680', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('681', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('682', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('683', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('684', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('685', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('686', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('687', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('688', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('689', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('690', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('691', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('692', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('693', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('694', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('695', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('696', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('697', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('698', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('699', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('700', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('701', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('702', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('703', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('704', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('705', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('706', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('707', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('708', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('709', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('710', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('711', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('712', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('713', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('714', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('715', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('716', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('717', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('718', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('719', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('720', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('721', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('722', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('723', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('724', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('725', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('726', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('727', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('728', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('729', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('730', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('731', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('732', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('733', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('734', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('735', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('736', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('737', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('738', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('739', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('740', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('741', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('742', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('743', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('744', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('745', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('746', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('747', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('748', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('749', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('750', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('751', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('752', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('753', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('754', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('755', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('756', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('757', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('758', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('759', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('760', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('761', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('762', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('763', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('764', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('765', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('766', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('767', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('768', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('769', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('770', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('771', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('772', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('773', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('774', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('775', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('776', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('777', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('778', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('779', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('780', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('781', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('782', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('783', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('784', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('785', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('786', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('787', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('788', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('789', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('790', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('791', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('792', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('793', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('794', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('795', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('796', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('797', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('798', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('799', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('800', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('801', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('802', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('803', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('804', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('805', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('806', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('807', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('808', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('809', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('810', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('811', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('812', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('813', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('814', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('815', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('816', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('817', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('818', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('819', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('820', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('821', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('822', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('823', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('824', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('825', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('826', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('827', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('828', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('829', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('830', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('831', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('832', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('833', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('834', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('835', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('836', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('837', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('838', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('839', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('840', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('841', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('842', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('843', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('844', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('845', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('846', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('847', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('848', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('849', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('850', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('851', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('852', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('853', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('854', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('855', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('856', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('857', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('858', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('859', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('860', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('861', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('862', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('863', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('864', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('865', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('866', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('867', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('868', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('869', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('870', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('871', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('872', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('873', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('874', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('875', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('876', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('877', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('878', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('879', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('880', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('881', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('882', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('883', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('884', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('885', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('886', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('887', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('888', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('889', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('890', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('891', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('892', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('893', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('894', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('895', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('896', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('897', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('898', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('899', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('900', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('901', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('902', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('903', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('904', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('905', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('906', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('907', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('908', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('909', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('910', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('911', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('912', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('913', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('914', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('915', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('916', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('917', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('918', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('919', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('920', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('921', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('922', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('923', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:07', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('924', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('925', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('926', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('927', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('928', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('929', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('930', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('931', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('932', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('933', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('934', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('935', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('936', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('937', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('938', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('939', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('940', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('941', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('942', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('943', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('944', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('945', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('946', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('947', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('948', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('949', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('950', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('951', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('952', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('953', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('954', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('955', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('956', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('957', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('958', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('959', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('960', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('961', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('962', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('963', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('964', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('965', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('966', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('967', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('968', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('969', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('970', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('971', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('972', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('973', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('974', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('975', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('976', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('977', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('978', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('979', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('980', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('981', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('982', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('983', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('984', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('985', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('986', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('987', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('988', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('989', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('990', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('991', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('992', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('993', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('994', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('995', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('996', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('997', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('998', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('999', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1000', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1001', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1002', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1003', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1004', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1005', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1006', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1007', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1008', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1009', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1010', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1011', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1012', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1013', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1014', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1015', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1016', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1017', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1018', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1019', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1020', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1021', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1022', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1023', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1024', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1025', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1026', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1027', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1028', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1029', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1030', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1031', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1032', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1033', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1034', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1035', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1036', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1037', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1038', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1039', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1040', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1041', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1042', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1043', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1044', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1045', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1046', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1047', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1048', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1049', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1050', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1051', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1052', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1053', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1054', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1055', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1056', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1057', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1058', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1059', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1060', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1061', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1062', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1063', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1064', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1065', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1066', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1067', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1068', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1069', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1070', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1071', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1072', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1073', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1074', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1075', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1076', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1077', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1078', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1079', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1080', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1081', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1082', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1083', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1084', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1085', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1086', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1087', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1088', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1089', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1090', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1091', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1092', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1093', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1094', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1095', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1096', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1097', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1098', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1099', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1100', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1101', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1102', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1103', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1104', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1105', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1106', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1107', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1108', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1109', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1110', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1111', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1112', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1113', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1114', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1115', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1116', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1117', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1118', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1119', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1120', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1121', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1122', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1123', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1124', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1125', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1126', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1127', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1128', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1129', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1130', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1131', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1132', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1133', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1134', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1135', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1136', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1137', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1138', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1139', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1140', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1141', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1142', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1143', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1144', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1145', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1146', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1147', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1148', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1149', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1150', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1151', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1152', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1153', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1154', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1155', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1156', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1157', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1158', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1159', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1160', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1161', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1162', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1163', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1164', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1165', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1166', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1167', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:08', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1168', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1169', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1170', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1171', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1172', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1173', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1174', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1175', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1176', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1177', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1178', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1179', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1180', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1181', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1182', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1183', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1184', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1185', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1186', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1187', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1188', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1189', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1190', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1191', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1192', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1193', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1194', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1195', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1196', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1197', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1198', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1199', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1200', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1201', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1202', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1203', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1204', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1205', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1206', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1207', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1208', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1209', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1210', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1211', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1212', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1213', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1214', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1215', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1216', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1217', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1218', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1219', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1220', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1221', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1222', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1223', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1224', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1225', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1226', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1227', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1228', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1229', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1230', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1231', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1232', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1233', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1234', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1235', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1236', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1237', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1238', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1239', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1240', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1241', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1242', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1243', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1244', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1245', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1246', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1247', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1248', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1249', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1250', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1251', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1252', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1253', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1254', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1255', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1256', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1257', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1258', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1259', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1260', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1261', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1262', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1263', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1264', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1265', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1266', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1267', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1268', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1269', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1270', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1271', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1272', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1273', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1274', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1275', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1276', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1277', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1278', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1279', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1280', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1281', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1282', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1283', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1284', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1285', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1286', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1287', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1288', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1289', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1290', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1291', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1292', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1293', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1294', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1295', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1296', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1297', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1298', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1299', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1300', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1301', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1302', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1303', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1304', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1305', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1306', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1307', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1308', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1309', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1310', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1311', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1312', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1313', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1314', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1315', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1316', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1317', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1318', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1319', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1320', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1321', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1322', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1323', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1324', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1325', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1326', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1327', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1328', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1329', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1330', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1331', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1332', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1333', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1334', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1335', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1336', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1337', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1338', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1339', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1340', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1341', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1342', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1343', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1344', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1345', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1346', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1347', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1348', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1349', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1350', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1351', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1352', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1353', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1354', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1355', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1356', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1357', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1358', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1359', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1360', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1361', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1362', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1363', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1364', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1365', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1366', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1367', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1368', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1369', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1370', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1371', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1372', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1373', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1374', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1375', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1376', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1377', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1378', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1379', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1380', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1381', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1382', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1383', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1384', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1385', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1386', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1387', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1388', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1389', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1390', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1391', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1392', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1393', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1394', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1395', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1396', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1397', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1398', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1399', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1400', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1401', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1402', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1403', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1404', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1405', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1406', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1407', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1408', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1409', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1410', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1411', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1412', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1413', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1414', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1415', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1416', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1417', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1418', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1419', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1420', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1421', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1422', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1423', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1424', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1425', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1426', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1427', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1428', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1429', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1430', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:09', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1431', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1432', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1433', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1434', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1435', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1436', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1437', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1438', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1439', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1440', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1441', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1442', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1443', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1444', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1445', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1446', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1447', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1448', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1449', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1450', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1451', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1452', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1453', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1454', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1455', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1456', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1457', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1458', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1459', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1460', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1461', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1462', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1463', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1464', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1465', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1466', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1467', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1468', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1469', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1470', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1471', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1472', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1473', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1474', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1475', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1476', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1477', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1478', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1479', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1480', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1481', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1482', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1483', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1484', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1485', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1486', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1487', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1488', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1489', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1490', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1491', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1492', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1493', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1494', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1495', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1496', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1497', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1498', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1499', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1500', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1501', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1502', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1503', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1504', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1505', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1506', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1507', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1508', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1509', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1510', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1511', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1512', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1513', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1514', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1515', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1516', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1517', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1518', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1519', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1520', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1521', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1522', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1523', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1524', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1525', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1526', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1527', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1528', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1529', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1530', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1531', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1532', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1533', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1534', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1535', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1536', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1537', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1538', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1539', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1540', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1541', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1542', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1543', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1544', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1545', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1546', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1547', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1548', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1549', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1550', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1551', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1552', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1553', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1554', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1555', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1556', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1557', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1558', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1559', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1560', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1561', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1562', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1563', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1564', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1565', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1566', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1567', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1568', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1569', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1570', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1571', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1572', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1573', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1574', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1575', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1576', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1577', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1578', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1579', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1580', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1581', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1582', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1583', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1584', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1585', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1586', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1587', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1588', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1589', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1590', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1591', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1592', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1593', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1594', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1595', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1596', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1597', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1598', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1599', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1600', '-1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1601', '0', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`) VALUES ('1602', '1', '2022', NULL, '2', '40', '12G0140001', 'M-pesa', '1.00', 'ws_CO_01072022121904372701842081', 'QG14O0928G', NULL, '0.00', '0.00', '0.00', 'QG14O0928G', '2022-07-01', NULL, 'unremitted', 'System', '2022-07-01 12:20:10', NULL, '');
INSERT INTO `invoicepayments` (`id`, `month`, `year`, `landlordid`, `propertyid`, `tenantid`, `invoiceid`, `method`, `amount_paid`, `CheckoutRequestID`, `mpesa_receipt_no`, `phone`, `commission`, `vat`, `landlord_amount`, `refno`, `date`, `status`, `remittance_status`, `recordcreator`, `recordcreated`, `reversaltime`, `reversalreason`