<?php

defined('BASEPATH') OR exit('No direct script access allowed');

$config['ci_bootstrap'] = array(
    // Site name
    'site_name' => 'CLOUD VENUS',
    // Default page title prefix
    'site_name' => 'CLOUD VENUS',
    'page_title_prefix' => '',
    // Default page title
     'page_title' => '',
    // Default meta data
    'meta_data' => array(
        'author' => 'joel mwas, geofrey kyalo',
        'description' => 'Cloud Venus Real Estate Management System',
        'keywords' => 'Cloud Office Real Estate Management System'
    ),
    // Default scripts to embed at page head or end
    'scripts' => array(
        'head' => array(
           // 'assets/dist/admin/lib.min.js',
           // 'assets/dist/admin/app.min.js',
          'assets/dist/admin/plugins/jquery/jquery.min.js',

          ),
          
          
        'foot' => array(
          
        'assets/dist/admin/plugins/bootstrap/js/bootstrap.bundle.min.js',
        'assets/dist/admin/adminlte.js',
        'assets/js/jquery.validate.js',
        'assets/js/validation.js',
        'https://unpkg.com/sweetalert/dist/sweetalert.min.js',
        'assets/dist/admin/plugins/datatables/jquery.dataTables.min.js',
        
        'assets/dist/admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js',
        'assets/dist/admin/plugins/datatables-responsive/js/dataTables.responsive.min.js',
        'assets/dist/admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js',
        'assets/dist/admin/plugins/datatables-buttons/js/dataTables.buttons.min.js',
        'assets/dist/admin/plugins/datatables-buttons/js/buttons.bootstrap4.min.js',
        'assets/dist/admin/plugins/jszip/jszip.min.js',
        'assets/dist/admin/plugins/pdfmake/pdfmake.min.js',
        'assets/dist/admin/plugins/pdfmake/vfs_fonts.js',
        'assets/dist/admin/plugins/datatables-buttons/js/buttons.html5.min.js',
        'assets/dist/admin/plugins/datatables-buttons/js/buttons.print.min.js',
        'assets/dist/admin/plugins/datatables-buttons/js/buttons.colVis.min.js',
                 
        ),
    ),
    // Default stylesheets to embed at page head
    'stylesheets' => array(
        'screen' => array(
            'assets/dist/admin/adminlte.css',
            'https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback',
            'assets/dist/admin/plugins/fontawesome-free/css/all.min.css',
            'https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css',
            'assets/dist/admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css',
            'assets/dist/admin/plugins/datatables-responsive/css/responsive.bootstrap4.min.css',
            'assets/dist/admin/plugins/datatables-buttons/css/buttons.bootstrap4.min.css',

          )
    ),
    // Default CSS class for <body> tag
    'body_class' => 'skin-blue',
    // Multilingual settings
    'languages' => array(
    ),
    // Menu items
    'menu' => array(
        'dashboard' => array(
            'name' => 'Dashboard',
            'url' => '',
            'icon' => 'fa fa-dashboard ',
        ),
        'landlords' => array(
            'name' => 'LandLords',
            'url' => 'landlords',
            'icon' => 'fa fa-users',

            'children' => array (
                'Add Landlord' =>'landlords/add',
                'List Landlord' => 'landlords',
                'Import Landlord' => 'units',
            )
        ),
        
        'propertymanagement' => array(
            'name' => 'Properties',
            'url' => 'properties',
            'icon' => 'fa fa-building',

            'children' => array (
                'Add Property' => 'properties/add',
                'All Properties' =>'properties',
                'Property Types' => 'units',
                'Units Types' => 'unittypes',
            )
        ),
        
        'tenants' => array(
            'name' => 'Tenants',
            'url' => 'tenants',
            'icon' => 'fa fa-users',
            
            'children' => array (
                'Add Tenant' =>'tenants/add',
                'List Tenants' => 'tenants',
                'Import Tenants' => 'tenants/import',
            )
        ),
      
        'subscriptions' => array(
            'name' => 'Leases',
            'url' => 'subscriptions',
            'icon' => 'fa fa-money',
        ),
        
   'sms' => array(
            'name' => 'BulkSMS',
            'url' => 'sms',
            'icon' => 'fa fa-phone',
        ),
               
        'accounting' => array(
            'name' => 'Accounting',
            'url' => 'invoices',
            'icon' => 'fa fa-money',
            'children' => array(
                'Rent Invoices' => 'invoices',
                'Invoice Payment Transactions' => 'invoices/payments',
                'Utility Bills' => 'utilitybills',
                'Utility Payment Transactions' => 'utilitybills/payments',
                'Landlord Vouchers' => 'vouchers',
                'Voucher Payment Transactions' => 'vouchers/payments',
                'Property Expenses' => 'expenses',
                'Office Expenditure' => 'expenditures'

            )
        ),

           
        
        
        'reports' => array(
            'name' => 'Reports',
            'url' => 'reports',
            'icon' => 'fa fa-list ',
 
 
            'children' => array(
                'Invoices Report' => 'home/invoicefilter',
                'Invoice Payments Report' => 'home/paymentfilter',
                 'Utility Bills Report'   => 'home/utilitybillsfilter',
                'Property Expenses Report' => 'home/expensefilter',
                'Landlord Voucher Report' => 'home/vouchersfilter',
                'Landlord Statement' => 'home/statementstatusfilter',
                'Income Report'   => 'home/incomefilter',
                'Expenditure Report' => 'home/expenditurefilter',
                'Income VS Expenditure Report' => 'home/balancefilter',
 
            )
        ),


        'util' => array(
            'name' => 'Backup',
            'url' => 'util/list_db',
            'icon' => 'fa fa-cogs',
        ),


        'panel' => array(
            'name' => 'Admin Panel',
            'url' => 'panel',
            'icon' => 'fa fa-cog ',
            'children' => array(
                'Users Accounts' => 'panel/admin_user',
                'Create User Account' => 'panel/admin_user_create',
                'System Settings' => 'panel/settings',
               //'Accounts Group'  => 'panel/admin_user_group',
            )
        ),
        
        'logout' => array(
            'name' => 'Sign Out',
            'url' => 'panel/logout',
            'icon' => 'fa fa-sign-out ',
        )
    ),
    // Login page
    'login_url' => 'admin/login',
    // Restricted pages
    'page_auth' => array(
        'landlords' => array('webmaster', 'Administrators', 'Managers','Front_Office'),
        'properties' => array('webmaster', 'Administrators', 'Accounting', 'Managers','Front_Office'),
        'units' => array('webmaster', 'Administrators',   'Managers','Front_Office'),
        'tenants' => array('webmaster', 'Administrators',  'Accounting',  'Managers','Front_Office'),
        'units' => array('webmaster', 'Administrators',   'Managers','Front_Office'),      
        'subscriptions' => array('webmaster', 'Administrators','Managers','Front_Office' ),
        'invoices' => array('webmaster', 'Administrators', 'Accounting','Managers','Front_Office'),
        'reports' => array('webmaster', 'Administrators'),
        'expenses' => array('webmaster', 'Administrators', 'Accounting','Managers','Front_Office'),
        'invoices' => array('webmaster', 'Administrators', 'Accounting','Managers','Front_Office'),
        'invoices/payments' => array('webmaster', 'Administrators', 'Accounting','Managers','Front_Office'),
        'user/create' => array('webmaster', 'Administrators'),
        'user/group' => array('webmaster', 'Administrators'),
        'panel' => array('webmaster', 'Administrators'),
        'panel/admin_user' => array('webmaster', 'Administrators'),
        'panel/admin_user_create' => array('webmaster'),
        'property' => array('webmaster', 'Administrators', 'LandLord','Managers'),
        'property/units' => array('webmaster', 'Administrators','Managers'),
        'property/rentals' => array('webmaster', 'Administrators'),
        'panel/admin_user_group' => array('webmaster', 'Administrators'),
        'util' => array('webmaster'),
        'util/list_db' => array('webmaster'),
        'util/backup_db' => array('webmaster'),
        'util/restore_db' => array('webmaster'),
        'util/remove_db' => array('webmaster'),
    ),

    // AdminLTE settings
    'adminlte' => array(
        'body_class' => array(
            'webmaster' => 'skin-blue',
            'Administrators' => 'skin-blue',
            'Managers' => 'skin-blue',
            'Accounting' => 'skin-blue',
            'Front_Office'=> 'skin-blue',
        )
    ),
    // Useful links to display at bottom of sidemenu
    'useful_links' => array(
    /* array(
      'auth'    => array('webmaster', 'admin', 'manager', 'staff'),
      'name'    => 'Frontend Website',
      'url'   => '',
      'target'  => '_blank',
      'color'   => 'text-aqua'
      ), */
    ),
    // Debug tools
    'debug' => array(
        'view_data' => FALSE,
        'profiler' => FALSE
    ),
);

/*
  | -------------------------------------------------------------------------
  | Override values from /application/config/config.php
  | -------------------------------------------------------------------------
 */
$config['sess_cookie_name'] = 'ci_session_admin';


