<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customers extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
        $this->load->model('customers_model');
	}


	public function index()
	{
         $user = $this->ion_auth->user()->row();
         $loggeduserid =  $user->id;
         $query = $this->db->get_where('admin_users_groups', array('user_id'=>$loggeduserid));
          $this->mViewData['usergroup']  = $query->row('group_id');

        $this->mViewData['customers'] =$this->customers_model->get_all_customers();
        

        		$this->render('_layouts/customer');

    }
    
    public function customer_add(){

        $data = array(
            'name' => $this->input->post('name'),
            'address' => $this->input->post('address'),
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
        );

        $insert = $this->customers_model->customer_add($data);
        echo json_encode(array("status" => TRUE));
    }
    

    public function ajax_edit($id)
    {
        $data = $this->customers_model->get_by_id($id);

        echo json_encode($data);
    }

    public function customer_update()

    {
        $data = array(

            'name' => $this->input->post('name'),
           'address' => $this->input->post('address'),
           'email' => $this->input->post('email'),
           'phone' => $this->input->post('phone'),

        );

      $this->customers_model->customer_update(array('id' => $this->input->post('id')), $data);
       echo json_encode(array("status" => TRUE));

         //var_dump($data);
    }

    public function customer_delete($id){

        $this->customers_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

}
