<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Expenditures extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
        $this->load->model('expenditures_model');
	}


	public function index()
	{
          $user = $this->ion_auth->user()->row();
         $loggeduserid =  $user->id;
         $query = $this->db->get_where('admin_users_groups', array('user_id'=>$loggeduserid));
          $this->mViewData['usergroup']  = $query->row('group_id');
         
        $this->mViewData['expenditures'] =$this->expenditures_model->get_all_expenditures();
        
       // echo $uid; 

        	$this->render('_layouts/expenditure');

    }
    
    
    public function expenditureview()
    {
        

        $this->render('_layouts/expenditureadd');

    }
    
    
    public function expenditure_add(){

        $data = array(
            'type' => $this->input->post('type'),
            'description' => $this->input->post('description'),
            'amount' => $this->input->post('amount'),
            'vat' => $this->input->post('vat'),
            'officeid' =>$this->input->post('office'),
            'paidto' => $this->input->post('paidto'),    
            'date' => $this->input->post('date'),
            'refno' => $this->input->post('refno'),
        );

          $insert = $this->expenditures_model->expenditure_add($data);
        echo json_encode(array("status" => TRUE));
    }
    
    

    public function ajax_edit($id)
    {
        $data = $this->expenditures_model->get_by_id($id);

        echo json_encode($data);
    }

    public function expenditure_update()

    {
       $data = array(
            'type' => $this->input->post('type'),
            'description' => $this->input->post('description'),
            'amount' => $this->input->post('amount'),
            'vat' => $this->input->post('vat'),
            'officeid' =>$this->input->post('office'),
            'paidto' => $this->input->post('paidto'),    
            'date' => $this->input->post('date'),
            'refno' => $this->input->post('refno'),
        );

        $this->expenditures_model->expenditure_update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }


public function pdf($id) {



        $this->load->library('Pdf');
        $data['id'] = $id;

 
        $this->load->view('reports/expenditurepdf', $data);



    }

    public function expenditure_delete($id){

        $this->expenditures_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

}
