<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Subscriptions extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('subscriptions_model');
    }

    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');

        $this->mViewData['subscriptions'] = $this->subscriptions_model->get_all_subscriptions();


        $this->render('_layouts/subscription');
    }

    public function subscription_add() {

        $tenant = $this->input->post('tenantid');
        $query = $this->db->get_where('tenants', array('id' => $tenant));

        foreach ($query->result() as $row) {

            $tenant_name = $row->fullname;
            $tenant_id = $row->id;
            $unit_id = $row->unit_id;
        }


        //$unit = $this->input->post('unitid');

        $query = $this->db->get_where('units', array('id' => $unit_id));

        foreach ($query->result() as $row) {

            $rent = $row->rent;
            $rent_deposit = $row->rent_deposit;
            $water_deposit = $row->water_deposit;
            $electricity_deposit = $row->electricity_deposit;
            $deposit = $rent_deposit + $water_deposit + $electricity_deposit;
            $property_id = $row->property_id;
            //$property_name = $row->property_name;
            $unit_id = $row->id;
            $unit_code = $row->unit_code;
            $ref = $property_id . $unit_code .$tenant_id;
        }


        $data = array(
            'unit_code' => $unit_code,
            'ref' => $ref,
            'unit_id' => $unit_id,
            'tenant_id' => $tenant_id,
            'property_id' => $property_id,
            'date' => $this->input->post('date'),
            'rent' => $rent,
            'deposit' => $deposit,
            'status' => 'Active',
        );

        $insert = $this->subscriptions_model->subscription_add($data);

        $data1 = array(
            'status' => 'Active',
        );

        $this->db->where('id', $tenant_id);
        $this->db->update('tenants', $data1);

        echo json_encode(array("status" => TRUE));
    }

    public function ajax_details($id) {
        $data = $this->subscriptions_model->get_by_id($id);

        echo json_encode($data);
    }

    public function terminate($id) {
        
         $this->mViewData['id'] = $id;

         $this->render('_layouts/terminatesubscription');

    }  

    public function vacate() {
        
        $subid= $this->input->post('subid');
        $unitid= $this->input->post('unitid');
         
        $data = array (

                'terminate_date' => $this->input->post('date'),
                'waterdepo_refund' => $this->input->post('waterdepo'),
                'elecdepo_refund' => $this->input->post('elecdepo'),
                'rentdepo_refund' => $this->input->post('rentdepo'),
                'vacate_comments' => $this->input->post('comments'),
                'status'=>'Terminated',

        );

        $this->db->where('id',$subid);
        $this->db->update('subscription', $data);


        $data = array (
            'status' => 'Vacant'
        );
         $this->db->where('id',$unitid);
        $this->db->update('units', $data);
    

        $this->index();

    }

    public function subscription_update() {
        $data = array(
            //'unitcode' => $this->input->post('unitcode'),
            //'tenantid' => $this->input->post('tenantid'),
            'date' => $this->input->post('date'),
            // 'amount' => $this->input->post('amount'),
            // 'paid' => $this->input->post('paid'),
            //  'balance' => $this->input->post('balance'),
            'status' => 'Active',
        );

        $this->subscriptions_model->subscription_update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function subscription_delete($id) {

        $this->subscriptions_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

}
