<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Tenants extends Admin_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('tenants_model');
    }
    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['tenants'] = $this->tenants_model->get_all_tenants();
        $this->render('_layouts/tenant');
    }
    public function add() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        //$this->mViewData['landlords'] = $this->landlords_model->get_all_landlords();
        $this->render('_layouts/addTenant');
    }
    public function tenant_add() {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('fullname', 'Full Name', 'required');
        $this->form_validation->set_rules('idno', 'Id Number', 'required');
        $this->form_validation->set_rules('phone', 'Phone Number', 'required');
        $this->form_validation->set_rules('property_id', 'Property Name', 'required');
        $this->form_validation->set_rules('unit_code', 'Unit', 'required');
        if ($this->form_validation->run() == FALSE) {
            echo validation_errors();
        } else {
            $property_id = $this->input->post('property_id');
            $query = $this->db->get_where('property', array('id' => $property_id));
            foreach ($query->result() as $row) {
                $property_name = $row->property_name;
            }
            $unit_code = $this->input->post('unit_code');
            $query = $this->db->get_where('units', array('unit_code' => $unit_code));
            foreach ($query->result() as $row) {
                $unit_id = $row->id;
            }
            $update = array('status' => 'Occupied');
            $this->db->where('id', $unit_id);
            $this->db->update('units', $update);
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $idno = $this->input->post('idno');
            $data = array('fullname' => $this->input->post('fullname'), 
                          'idno' => $idno, 'phone' => $this->input->post('phone'), 
                          'email' => $this->input->post('email'), 
                          'property_id' => $property_id, 
                          'unit_id' => $unit_id, 'unit_code' => $unit_code, 
                          'record_creator' => $username);
            $insert = $this->tenants_model->tenant_add($data);
            
            
            //Add tenant Subscription
            $query = $this->db->get_where('tenants', array('idno' => $idno));
            foreach ($query->result() as $row) {
                $tenant_name = $row->fullname;
                $tenant_id = $row->id;
                $unit_id = $row->unit_id;
            }
            
            
            //$unit = $this->input->post('unitid');
            $query = $this->db->get_where('units', array('id' => $unit_id));
            foreach ($query->result() as $row) {
                $rent = $row->rent;
                $rent_deposit = $row->rent_deposit;
                $water_deposit = $row->water_deposit;
                $electricity_deposit = $row->electricity_deposit;
                $property_id = $row->property_id;
                $property_name = $row->property_name;
                $unit_id = $row->id;
                $unit_code = $row->unit_code;
            }
            $date = date('Y-m-d');
            $year = date('Y');
            $month = date('F');
            $mon = date('m');
            $ref = $property_id . $unit_code . $tenant_id;
            $data = array('ref' => $ref, 
                          'unit_code' => $unit_code, 
                          'unit_id' => $unit_id, 
                          'tenant_id' => $tenant_id, 
                          'property_id' => $property_id, 
                          'date' => $date, 
                          'rent' => $rent, 
                          'rent_deposit' => $rent_deposit, 
                          'water_deposit' => $water_deposit, 
                          'electricity_deposit' => $electricity_deposit, 
                          'status' => 'Active', 
                          'record_creator' => $username);
            $this->db->insert('subscription', $data);
            $data1 = array('status' => 'Active',);
            $this->db->where('id', $tenant_id);
            $this->db->update('tenants', $data1);
            
            
            //Add tenant Invoice
            $total_deposits = $water_deposit + $electricity_deposit + $rent_deposit;
            $data = array('property_id' => $property_id, 
                          'unit_code' => $unit_code, 
                          'tenant_id' => $tenant_id, 
                          'amount' => $rent, 'year' => $year, 
                          'month' => $month, 
                          'description' => 'Rent for ' . $month, 
                          'status' => 'Due', 'balance' => $rent, 
                          'tax_Status' => 'Taxable', 
                          'Commisionable' => 'Yes', 
                          'invoicedate' => $date, 
                          'refid' => $year . $mon . $property_id . $unit_code . $tenant_id);
            $this->db->insert('invoices', $data);
            //Create tenant Deposits Invoice
            $data = array('property_id' => $property_id, 
                          'unit_code' => $unit_code, 
                          'tenant_id' => $tenant_id, 
                          'amount' => $total_deposits, 
                          'year' => $year, 
                          'month' => $month, 
                          'description' => 'Rent Deposit Ksh ' . $rent_deposit . ' Water Deposit Ksh ' . $water_deposit . ' Electricity Deposit Ksh' . $electricity_deposit, 
                          'status' => 'Due', 'balance' => $total_deposits, 
                          'tax_Status' => 'Non Taxable', 
                          'Commisionable' => 'No', 
                          'invoicedate' => $date, 
                          'refid' => $year . $mon . $property_id . $unit_code . $tenant_id);
            $res = $this->db->insert('invoices', $data);
            
            //Send a Welcome SMS to Tenant
            if ($res == true) {
                 $username = "jora";
                $apikey = "f78691be39edff5278c3ae8ac6b32fba291127ba1ec6a77b613bbd958500c77c";
                $recipients = $this->input->post('phone');
                $message = "Welcome to Geomary Luxury Homes. House " . $property_name . ' Unit ' . $unit_code . '.';
                $from = "JORA-LTD";
                // Create a new instance of our awesome gateway class
                $gateway = new AfricasTalkingGateway($username, $apikey);
                $results = $gateway->sendMessage($recipients, $message, $from);
                foreach ($results as $result) {
                    // status is either "Success" or "error message"
                    // $phone=$result->number;
                    $status = $result->status;
                    $cost = $result->cost;
                }
                $this->session->set_flashdata('success', "Tenant added successfully");
                redirect('admin/tenants');
            } else {
                $this->session->set_flashdata('error', "Record Not Inserted");
            }
        }
    }
    public function create_tenant_invoice() {
        $tenant_id = $this->input->post('tenant_id');
        $invoice_type = $this->input->post('invoice_type');
        $description = $this->input->post('description');
        $amount = $this->input->post('amount');
        $tax_status = $this->input->post('tax_status');
        $query = $this->db->get_where('tenants', array('id' => $tenant_id));
        foreach ($query->result() as $row) {
            $property_id = $row->property_id;
            $unit_code = $row->unit_code;
        }
        $date = date('Y-m-d');
        $year = date('Y');
        $month = date('F');
        $mon = date('m');
        $ref = $year . $mon . $property_id . $unit_code . $tenant_id;
        $data = array('property_id' => $property_id, 'unit_code' => $unit_code, 'tenant_id' => $tenant_id, 'year' => $year, 'month' => $month, 'invoice_type' => $invoice_type, 'invoicedate' => $date, 'tax_status' => $tax_status, 'description' => $description, 'amount' => $amount, 'balance' => $amount, 'status' => 'Due', 'refid' => $ref,);
        $this->db->insert('invoices', $data);
        echo json_encode(array("status" => TRUE));
    }
    public function add_tenant_subscription() {
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $tenant_id = $this->input->post('tenant_id');
        $unit_code = $this->input->post('unit_code');
        //$subscription_date = $this->input->post('date');
        $query = $this->db->get_where('units', array('unit_code' => $unit_code));
        foreach ($query->result() as $row) {
            $rent = $row->rent;
            $rent_deposit = $row->rent_deposit;
            $water_deposit = $row->water_deposit;
            $electricity_deposit = $row->electricity_deposit;
            $property_id = $row->property_id;
            $unit_id = $row->id;
            $unit_code = $row->unit_code;
        }
        $date = date('Y-m-d');
        $year = date('Y');
        $month = date('F');
        $mon = date('m');
        $ref = $property_id . $unit_code . $tenant_id;
        $data = array('ref' => $ref, 'unit_code' => $unit_code, 'unit_id' => $unit_id, 'tenant_id' => $tenant_id, 'property_id' => $property_id, 'date' => $date, 'rent' => $rent, 'rent_deposit' => $rent_deposit, 'water_deposit' => $water_deposit, 'electricity_deposit' => $electricity_deposit, 'status' => 'Active', 'record_creator' => $username,);
        $this->db->insert('subscription', $data);
        $update = array('status' => 'Occupied');
        $this->db->where('id', $unit_id);
        $this->db->update('units', $update);
        //        //Add tenant Invoice
        $total_deposits = $water_deposit + $electricity_deposit + $rent_deposit;
        $data = array('property_id' => $property_id, 'unit_code' => $unit_code, 'tenant_id' => $tenant_id, 'amount' => $rent, 'year' => $year, 'month' => $month, 'description' => 'Rent for ' . $month, 'status' => 'Due', 'balance' => $rent, 'tax_Status' => 'Taxable', 'Commisionable' => 'Yes', 'invoicedate' => $date, 'refid' => $year . $mon . $property_id . $unit_code . $tenant_id,);
        $this->db->insert('invoices', $data);
        //Create tenant Deposits Invoice
        $data = array('property_id' => $property_id, 'unit_code' => $unit_code, 'tenant_id' => $tenant_id, 'amount' => $total_deposits, 'year' => $year, 'month' => $month, 'description' => 'Rent Deposit Ksh ' . $rent_deposit . ' Water Deposit Ksh ' . $water_deposit . ' Electricity Deposit Ksh' . $electricity_deposit, 'status' => 'Due', 'balance' => $total_deposits, 'tax_Status' => 'Non Taxable', 'Commisionable' => 'No', 'invoicedate' => $date, 'refid' => $year . $mon . $property_id . $unit_code . $tenant_id,);
        $this->db->insert('invoices', $data);
        echo json_encode(array("status" => TRUE));
    }
    public function ajax_edit($id) {
        $data = $this->tenants_model->get_by_id($id);
        echo json_encode($data);
    }
    public function tenant_update() {
        $property_id = $this->input->post('propery_id');
        $query = $this->db->get_where('property', array('id' => $property_id));
        foreach ($query->result() as $row) {
            $property_name = $row->property_name;
        }
        $unit_id = $this->input->post('unit_id');
        $query = $this->db->get_where('units', array('id' => $unit_id));
        foreach ($query->result() as $row) {
            $unit_code = $row->unit_code;
        }
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $data = array('fullname' => $this->input->post('fullname'), 'idno' => $this->input->post('idno'), 'phone' => $this->input->post('phone'), 'email' => $this->input->post('email'), 'propery_id' => $property_id, 'unit_id' => $unit_id, 'unit_code' => $unit_code, 'record_creator' => $username,);
        $this->tenants_model->tenant_update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }
    public function view_tenant($id) {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['id'] = $id;
        $this->render('_layouts/viewtenant');
    }
    public function ajaxTenantSearch() {
        $query = $this->input->get('query');
        $this->db->like('fullname', $query);
        $data = $this->db->get("tenants")->result();
        echo json_encode($data);
    }
    public function tenant_delete($id) {
        $this->tenants_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }
    public function vacate_tenant($id) {
        $query = $this->db->get_where('tenants', array('id' => $id));
        foreach ($query->result() as $row) {
            $unit_id = $row->unit_id;
        }
        $query = $this->db->get_where('subscription', array('tenant_id' => $id));
        foreach ($query->result() as $row) {
            $subscription_id = $row->id;
        }
        //Vacate Tenanta
        $data = array('Status' => 'Vacated',);
        $this->db->where('id', $id);
        $this->db->update('tenants', $data);
        //Update Units
        $data1 = array('status' => 'Vacant',);
        $this->db->where('id', $unit_id);
        $this->db->update('units', $data1);
        //Deactivate Subscription
        $data2 = array('status' => 'Terminated',);
        $this->db->where('id', $subscription_id);
        $this->db->update('subscription', $data2);
        echo json_encode(array("status" => TRUE));
    }
}
