<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Utilitybills extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('utilitybills_model');
    }

    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $office = $user->office;
        $this->mViewData['office'] = $user->office;

        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');

        $this->mViewData['utilitybills'] = $this->utilitybills_model->get_all_utilitybills();       

        $this->render('_layouts/utilitybill');
    }

    public function details($id) {


        $this->mViewData['utilitybillid'] = $id;
        $this->render('_layouts/utilitybilldetails');

        echo $id;
    }

    public function payments() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');

        $this->mViewData['payments'] = $this->utilitybills_model->get_all_utilitybillpayments();
        $this->render('_layouts/utilitybillpayments');
    }

    public function paymentreverse($id) {

        $this->mViewData['primarykey'] = $id;


        $this->render('_layouts/utilitybillpaymentreverse');
    }

    public function addpaymentreverse() {

        $id = $this->input->post('id');
        $billno = $this->input->post('billno');
        $paidreverse = $this->input->post('paid');
        $method = $this->input->post('method');

        $query = $this->db->get_where('utilitybills', array('id' => $billno));

        $amount = $query->row('amount');

        $amountpaid = $query->row('paid');
        $amountbal = $query->row('balance');

        $newbal = $amountbal + $paidreverse;
        $newpaid = $amountpaid - $paidreverse;

        if ($amount == $newbal) {
            $status = 'Due';
        }

        if ($newbal < $amount) {
            $status = 'Partial';
        }

        $data = array(
            'paid' => $newpaid,
            'balance' => $newbal,
            'status' => $status,
        );

        $this->db->where('id', $billno);
        $this->db->update('utilitybills', $data);


        $data2 = array(
            'status' => 'Reversed',
            'reversaltime' => time(),
            'reversalreason' => $this->input->post('reason'),
        );

        $this->db->where('id', $id);
        $this->db->update('utilitybillpayments', $data2);

        redirect('admin/utilitybills/payments');
    }

  

    public function utilitybill_add() {

        $property_id = $this->input->post('property');

        $query = $this->db->where('status', 'Active');

        $query = $this->db->get_where('subscription', array('property_id' => $property_id, 'status' => 'Active'));

        foreach ($query->result() as $row) {

            $property_id = $row->property_id;
            $unit_code = $row->unit_code;
            $tenant_id = $row->tenant_id;
            $rent = $row->rent;

            $refno = $this->input->post('year') . $this->input->post('month') . $this->input->post('unit') . $property_id . $unit_code;



            $this->db->where('refno', $refno);
            $query = $this->db->get('utilitybills');

            if ($query->num_rows() == 0) {

                $data = array(
                    'property_id' => $property_id,
                     'unit_code' => $unit_code,
                     'tenant_id' => $tenant_id,
                     'amount' => $this->input->post('amount'),
                     'year' => $this->input->post('year'),
                     'month' => $this->input->post('month'),
                     'name' =>  $this->input->post('name'),
                     'description' =>  $this->input->post('description'),
                     'status' => 'Due',
                     'balance' => $this->input->post('amount'),
                     'paid' => 0,
                     'date' => date('Y-m-d'),
                     'refno' => $refno,
                );

                $insert = $this->utilitybills_model->utilitybill_add($data);
            }
        }



        echo json_encode(array("status" => TRUE));
    }









    public function ajax_edit($id) {
        $data = $this->utilitybills_model->get_by_id($id);

        echo json_encode($data);
    }

    public function utilitybill_update() {

        $data = array(
            'property' => $this->input->post('property'),
            'month' => $this->input->post('month'),
        );

        $insert = $this->utilitybills_model->utilitybill_update($data);
        echo json_encode(array("status" => TRUE));
    }

    public function utilitybill_delete($id) {

        $this->utilitybills_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

    public function pdf($id) {

        $this->load->library('Pdf');
        $data['id'] = $id;

        $this->load->view('reports/utilitybillpdf', $data);
    }

    public function editutilitybill($id) {

        $this->mViewData['primarykey'] = $id;
        $this->render('_layouts/utilitybill-edit.php');

        // echo  $this->input->post('id');
    }

    public function payutilitybill($id) {

        $this->mViewData['utilitybillid'] = $id;
        $this->render('_layouts/payutility.php');
    }

    public function addpayment() {

         
        $bal = intval($this->input->post('balance'));
        $amt = intval($this->input->post('amountpaid'));

        if ($amt <= $bal) {

            $utilitybillid = $this->input->post('utilitybillid');            

            $balance = $this->input->post('balance');
            $paid = $this->input->post('paid');
            $amountpaid = $this->input->post('amountpaid');

            $newbalance = intval($balance) - intval($amountpaid);
            

             $method = $this->input->post('method');

            $newpaid = intval($paid) + intval($amountpaid);

            if ($newbalance > 0) {
                $status = 'Partial';
            }
            if ($newbalance <= 0) {
                $status = 'Paid';
            }

            $data = array(
                'paid' => $newpaid,
                'balance' => $newbalance,
                'status' => $status,
            );
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $this->db->where('id', $utilitybillid);
            $this->db->update('utilitybills', $data);

            $data2 = array(
                
                 'propertyid' =>$this->input->post('property'),
                 'utilitybill_id' => $utilitybillid,
                'tenantid' => $this->input->post('tenant'),
                'amount' => $amountpaid,
                'method' => $method,
                'date' => $this->input->post('date'),
                'refno' => $this->input->post('refno'),
                'record_creator' => $username,
                'status' => 'Paid',
                
            );

            $this->db->insert('utilitybillpayments', $data2);

            // echo json_encode(array("status" => TRUE));
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['id'] = $tenantid;

             redirect('admin/utilitybills');

        } else {

            $this->session->set_flashdata('category_error', 'The amount you are paying is large than the balance.');
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

}
