<div class="c">
    <!-- Content Header (Page header) -->

<?php if ($this->session->flashdata('category_error')) { ?>
    <div class="alert alert-danger"> <?= $this->session->flashdata('category_error') ?> </div>
<?php } ?>

<?php if ($this->session->flashdata('category_success')) { ?>
        <div class="alert alert-success"> <?= $this->session->flashdata('category_success') ?> </div>
    <?php } ?>


    <section class="content-header">
        <h1>
            <i class="fa fa-money"></i> Landlord Vouchers
        </h1>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12 text-right">
                <div class="form-group">
                    <a class="btn btn-primary btn-large" onclick="add_voucher()"><i class="fa fa-plus"></i> Generate Vouchers </a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box">



                    <div class="box-body table-responsive no-padding">


                        <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>

                                    <th>REF</th>
                                    <th>LANDLORD</th>
                                    <th>PROPERTY</th>
                                    <th>YEAR</th>
                                    <th>MONTH</th>
                                    <th>LANDLORD AMOUNT</th>
                                    <th>PAID</th>
                                    <th>BALANCE</th>
                                    <th>STATUS</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($vouchers as $voucher) { ?>
                                    <tr>
                                        <td><?php echo $voucher->refid; ?> </td>
                                        <td><?php

                                         $landlordid = $voucher->landlord_id;
                                         $query = $this->db->get_where('landlord', array('id'=>$landlordid));

                                         echo $query->row('fullname');

                                          ?> </td>
                                        <td><?php

                                         $propertyid = $voucher->property_id; 
                                         $query = $this->db->get_where('property', array('id'=>$propertyid));

                                         echo $query->row('property_name');
                                         ?> </td>



                                        <td><?php echo $voucher->year; ?> </td>
                                        <td><?php echo $voucher->month; ?> </td>
                                        <td><?php echo $voucher->amount; ?> </td>
                                        <td><?php echo $voucher->paid; ?> </td>
                                        <td><?php echo $voucher->balance; ?> </td>
                                        <td><?php echo $voucher->status; ?> </td>   
                                        <td>
                                            <?php if ($usergroup == 1 || $usergroup == 2|| $usergroup == 3|| $usergroup == 4) { ?>
                                                <a class="btn btn-danger" href ="<?php echo base_url(); ?>admin/vouchers/pdf/<?php echo $voucher->id; ?>">
                                                    <i class="fa fa-file-pdf-o" data-toggle="tooltip" title="PDF voucher"></i></a>
                                                <a class="btn btn-success" href ="<?php echo base_url(); ?>admin/vouchers/payvoucher/<?php echo $voucher->id; ?>">
                                                    <i class="fa fa-money" data-toggle="tooltip" title="Update Payment"></i></a>
                                            <?php } else { ?>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>

                    </div><!-- /.box-body -->



                </div><!-- /.box -->
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
                        $(document).ready(function () {
                            $('#table_id').DataTable();
                        });
                        var save_method; //for save method string
                        var table;




                        function add_pay()
                        {
                            save_method = 'addpay';
                            // $('#form')[0].reset(); // reset form on modals
                            $('#modal_pay').modal('show'); // show bootstrap modal
                            //$('.modal-title').text('Add Person'); // Set Title to Bootstrap modal title
                        }

                        function add_voucher()
                        {
                            save_method = 'add';
                            $('#form')[0].reset(); // reset form on modals
                            $('#modal_form').modal('show'); // show bootstrap modal
                            //$('.modal-title').text('Add Person'); // Set Title to Bootstrap modal title
                        }

                        function edit_voucher(id)
                        {
                            save_method = 'update';
                            $('#form')[0].reset(); // reset form on modals

                            //Ajax Load data from ajax
                            $.ajax({
                                url: "<?php echo site_url('admin/vouchers/ajax_edit/') ?>/" + id,
                                type: "GET",
                                dataType: "JSON",
                                success: function (data)
                                {

                                    $('[name="name"]').val(data.name);
                                    $('[name="description"]').val(data.description);
                                    $('[name="id"]').val(data.id);


                                    $('#modal_form').modal('show'); // show bootstrap modal when complete loaded
                                    $('.modal-title').text('Edit voucher'); // Set title to Bootstrap modal title

                                },
                                error: function (jqXHR, textStatus, errorThrown)
                                {
                                    alert('Error get data from ajax');
                                }
                            });
                        }



                        function save()
                        {
                            var url;
                            if (save_method == 'add')
                            {
                                url = "<?php echo base_url('admin/vouchers/voucher_add') ?>";
                            } else
                            {
                                url = "<?php echo site_url('admin/vouchers/voucher_update') ?>";
                            }

                            // ajax adding data to database
                            $.ajax({
                                url: url,
                                type: "POST",
                                data: $('#form').serialize(),
                                dataType: "JSON",
                                success: function (data)
                                {
                                    //if success close modal and reload ajax table
                                    $('#modal_form').modal('hide');
                                    location.reload();// for reload a page
                                },
                                error: function (jqXHR, textStatus, errorThrown)
                                {
                                    alert('Error adding / update data');
                                }
                            });
                        }

                        function delete_voucher(id)
                        {
                            if (confirm('Are you sure delete this data?'))
                            {
                                // ajax delete data from database
                                $.ajax({
                                    url: "<?php echo site_url('admin/vouchers/voucher_delete') ?>/" + id,
                                    type: "POST",
                                    dataType: "JSON",
                                    success: function (data)
                                    {

                                        location.reload();
                                    },
                                    error: function (jqXHR, textStatus, errorThrown)
                                    {
                                        alert('Error deleting data');
                                    }
                                });

                            }
                        }

</script>

<!-- Bootstrap modal -->
<div class="modal fade " id="modal_form" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h3 class="modal-title">Generate vouchers</h3>
            </div>
            <div class="modal-body form">
                <form action="#" id="form" class="form-horizontal">


                    <input type="hidden" value="" name="id"/>

                       

                    <div class="form-group">
                        <label class="control-label col-md-3">Year</label>
                        <div class="col-md-9">
                            <select name="year" class="form-control">
                                <option>2019</option>
                                <option>2020</option>
                                <option>2021</option>
                                <option>2022</option>

                            </select> 
                        </div>
                    </div>



                    <div class="form-group">
                        <label class="control-label col-md-3">Month</label>
                        <div class="col-md-9">
                            <select name="month" class="form-control">
                                <option  >January</option>
                                <option  >February</option>
                                <option  >March</option>
                                <option >April</option>
                                <option  >May</option>
                                <option  >June</option>
                                <option  >July</option>
                                <option  >August</option>
                                <option  >September</option>
                                <option  >October</option>
                                <option  >November</option>
                                <option >December</option>
                            </select> 
                        </div>
                    </div>




                </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="btnSave" onclick="save()" class="btn btn-primary">Save</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- End Bootstrap modal -->
<script src="<?php echo base_url('assests/js/jquery-3.2.1.min.js') ?>"></script>
<script src="<?php echo base_url('assests/datatables/js/jquery.dataTables.min.js') ?>"></script>
<script src="<?php echo base_url('assests/datatables/js/dataTablesbootstrap.js') ?>"></script>


