<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Patients extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->library('excel');
        $this->load->model('patients_model');
        $this->load->model('triage_model');
        $this->load->model('consultation_model');
        $this->load->model('laboratory_model');
        $this->load->model('queue_model');
        $this->load->model('tests_model');
        $this->load->model('visits_model');
        $this->load->model('prescription_model');
    }
    public function index()
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['patients'] = $this->patients_model->get_all();
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "Access Reception") !== false) {
            $this->render('Patients/index');
        } else {
            $this->render('errors/custom/access');
        }
    }
    public function add()
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "Add Patient") !== false) {
            $this->render('Patients/add');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function queue($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['patient'] = $this->patients_model->get_by_id($id);
        $this->mViewData['tests'] = $this->tests_model->get_all();
        $this->render('Patients/queue');
    }

    public function edit($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['patient'] = $this->patients_model->get_by_id($id);
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "Update Patient Details") !== false) {
            $this->render('Patients/edit');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function queue_list()
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['queues'] = $this->queue_model->get_all();
        $this->render('Patients/queues');
    }

    public function account($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['patient'] = $this->patients_model->get_by_id($id);
        $this->mViewData['triage'] = $this->triage_model->get_by_patient($id);
        $this->mViewData['consultation'] = $this->consultation_model->get_by_patient($id);
        $this->mViewData['lab'] = $this->laboratory_model->get_by_patient($id);
        $this->mViewData['visits'] = $this->visits_model->get_by_patient($id);
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "View Patient Medical History") !== false) {
            $this->render('Patients/account');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function accountS($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['patient'] = $this->patients_model->get_by_id($id);
        $this->mViewData['triage'] = $this->triage_model->get_by_patient($id);
        $this->mViewData['consultation'] = $this->consultation_model->get_by_patient($id);
        $this->mViewData['lab'] = $this->laboratory_model->get_by_patient($id);
        $this->mViewData['visits'] = $this->visits_model->get_by_patient($id);
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        $this->render('Patients/account');
    }

    public function medical_history($id, $pid)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['pid'] = $pid;
        $this->mViewData['id'] = $id;
        $this->mViewData['triage'] = $this->triage_model->get_by_visitId($id);
        $this->mViewData['consultation'] = $this->consultation_model->get_by_visitId($id);
        $this->mViewData['lab'] = $this->laboratory_model->get_by_visitId($id);
        $this->mViewData['prescription'] = $this->prescription_model->get_by_visitId($id);
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "View Patient Medical History") !== false) {
            $this->render('Patients/medical_history');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function save()
    {
        //Validation
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('name', 'Patient Name', 'required');
        $this->form_validation->set_rules('phone', 'Phone Number', 'required');
        $this->form_validation->set_rules('id_no', 'ID Number', 'required');
        $this->form_validation->set_rules('dob', 'Date of Birth', 'required');
        $this->form_validation->set_rules('residence', 'Place of Residence', 'required');
        $this->form_validation->set_rules('occupation', 'Occupation', 'required');
        if ($this->form_validation->run() == FALSE) {
            echo validation_errors();
        } else {
            //Logged In User
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $date = date('y-m-d H:i:s');
            //Get Inputs
            $name = $this->input->post('name');
            $phone = $this->input->post('phone');
            $idno = $this->input->post('id_no');
            $dob = $this->input->post('dob');
            $nok = $this->input->post('nok');
            $nok_phone = $this->input->post('nok_phone');
            $blood_group =  $this->input->post('blood_group');
            $gender =  $this->input->post('gender');
            $residence = $this->input->post('residence');
            $occupation = $this->input->post('occupation');
            $group_account = $this->input->post('group_account');
            $action = $this->input->post('action');

            //Generate Patient NO
            $num = $this->db->count_all_results('patient');
            $pNum = intval($num) + 1;
            $fNum = 0;
            if ($pNum < 10) {
                $fNum = '000' . $pNum;
            } else if ($pNum < 100) {
                $fNum = '00' . $pNum;
            } else {
                $fNum = $pNum;
            }
            $patientNumber = "P" . ""  . $fNum;

            $data = array(
                'patient_number' => $patientNumber,
                'name' => $name,
                'phone' => $phone,
                'id_no' => $idno,
                'dob' => $dob,
                'gender' => $gender,
                'nok' => $nok,
                'nok_phone' => $nok_phone,
                'blood_group' => $blood_group,
                'residence' => $residence,
                'occupation' => $occupation,
                'group_account' => $group_account,
                'record_creator' => $username,
                'date' => $date,
            );
            //Save Data
            $res = $this->patients_model->save($data);
            $pid = $this->db->insert_id();
            if ($res == true) {
                if ($action == 'queue') {
                    redirect('admin/patients/queue/' . $pid);
                } else {
                    $this->session->set_flashdata('success', "Patient added Successfully");
                    redirect('admin/patients');
                }
            } else {
                $this->session->set_flashdata('error', "Record Not Inserted");
                redirect('patients');
            }
        }
    }

    public function update()
    {
        //Validation
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('name', 'Patient Name', 'required');
        $this->form_validation->set_rules('phone', 'Phone Number', 'required');
        $this->form_validation->set_rules('id_no', 'ID Number', 'required');
        $this->form_validation->set_rules('dob', 'Date of Birth', 'required');
        $this->form_validation->set_rules('residence', 'Place of Residence', 'required');
        $this->form_validation->set_rules('occupation', 'Occupation', 'required');
        if ($this->form_validation->run() == FALSE) {
            echo validation_errors();
        } else {
            //Logged In User
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            //Get Inputs
            $name = $this->input->post('name');
            $phone = $this->input->post('phone');
            $idno = $this->input->post('id_no');
            $dob = $this->input->post('dob');
            $nok = $this->input->post('nok');
            $nok_phone = $this->input->post('nok_phone');
            $blood_group =  $this->input->post('blood_group');
            $gender =  $this->input->post('gender');
            $residence = $this->input->post('residence');
            $occupation = $this->input->post('occupation');
            $group_account = $this->input->post('group_account');

            $data = array(
                'name' => $name,
                'phone' => $phone,
                'id_no' => $idno,
                'dob' => $dob,
                'gender' => $gender,
                'nok' => $nok,
                'nok_phone' => $nok_phone,
                'blood_group' => $blood_group,
                'residence' => $residence,
                'occupation' => $occupation,
                'group_account' => $group_account,
                'record_creator' => $username,
            );
            //Update Data
            $this->db->where('id', $this->input->post('id'));
            $res = $this->db->update('patient', $data);
            if ($res == true) {
                $this->session->set_flashdata('success', "Patient Updated Successfully");
                redirect('admin/patients');
            } else {
                $this->session->set_flashdata('error', "Record Not Updated");
                redirect('admin/patients');
            }
        }
    }

    public function add_queue()
    {
        //Logged In User Session
        $date = date('Y-m-d');
        $user = $this->ion_auth->user()->row();
        $username = $user->username;

        //Validation
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('id', 'Patient Name', 'required');
        $this->form_validation->set_rules('from', 'From Department', 'required');
        $this->form_validation->set_rules('to', 'To Department', 'required');
        //$this->form_validation->set_rules('remarks[]', 'Remarks', 'required');
        if ($this->form_validation->run() == FALSE) {
            echo validation_errors();
        } else {
            $patient_id = $this->input->post('id');
            $from = $this->input->post('from');
            $to = $this->input->post('to');
            $type = $this->input->post('type');
            if (isset($_POST['remarks'])) {
                $remarks = ltrim(implode($_POST['remarks'], ";"), ";");
            }
            $record_creator = $username;

            $data = array(
                'patient_id' => $patient_id,
                'queue_from' => $from,
                'queue_to' => $to,
                'remarks' => $remarks,
                'type' => $type,
                'record_creator' => $record_creator
            );
            $res = $this->queue_model->save($data);
            if ($res == true) {
                //Register Visit
                $num = $this->db->count_all_results('visits');
                $invNum = intval($num) + 1;
                $fNum = 0;
                if ($invNum < 10) {
                    $fNum = '00' . $invNum;
                } else if ($invNum < 100) {
                    $fNum = '0' . $invNum;
                } else {
                    $fNum = $invNum;
                }
                $visit_id = $patient_id . "" . $fNum;

                $sql = $this->db->get_where('visits', array('patient_id' => $patient_id, 'date' => $date));
                if ($sql->num_rows() == 0) {
                    $data = array(
                        'patient_id' => $patient_id,
                        'visit_id' => $visit_id,
                        'date' => $date,
                        'record_creator' => $username,
                    );
                    $this->db->insert('visits', $data);
                }
                //Save Data
                $this->session->set_flashdata('success', "Patient Queued Successfully");
                redirect('admin/patients/queue_list');
            } else {
                $this->session->set_flashdata('error', "Patient Not Queued ");
                redirect('admin/patients/queue_list');
            }
        }
    }

    public function remove_queue($id)
    {
        $data = array(
            'status' => 'Attended',
        );
        $this->db->where('id', $id);
        $this->db->update('queues', $data);
        echo json_encode(array("status" => TRUE));
    }

    public function patient_search()
    {

        $username = trim($this->input->get('term', TRUE)); //get term parameter sent via text field. Not sure how secure get() is

        $this->db->select('name, id');
        $this->db->from('patient');
        $this->db->like('name', $username);
        $this->db->limit('3');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            $data['response'] = 'true'; //If username exists set true
            $data['message'] = array();

            foreach ($query->result() as $row) {
                $data['message'] = array(
                    'label' => $row->name . ' ' . $row->id,

                );
            }
        } else {
            $data['response'] = 'false'; //Set false if user not valid
        }

        echo json_encode($data);
    }
    public function delete_patient($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "Delete Patient") !== false) {
            $this->patients_model->delete_by_id($id);
            echo json_encode(array("status" => TRUE));
        } else {
            echo json_encode(array("status" => FALSE));
        }
    }
}
