<?php
    defined('BASEPATH') OR exit('No direct script access allowed');
     class Prescription extends Admin_Controller {
          public function __construct() {
            parent::__construct();
            $this->load->library('form_builder');
            $this->load->model('queue_model');
            $this->load->model('patients_model');
            $this->load->model('prescription_model');
        }
        
        public function index() {
            $date = date('Y-m-d');
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['prescription'] = $this->prescription_model->get_by_date($date);
            $group_id = $query->row('group_id');
            $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
            if (strpos($sql->row('rights'), "Access Prescription") !== false) {
                $this->render('Prescription/index');
            } else {
                $this->render('errors/custom/access');
            }
        }
        
        public function list() {
            $date = date('Y-m-d');
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['prescription'] = $this->prescription_model->get_by_date($date);
            $group_id = $query->row('group_id');
            $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
            if (strpos($sql->row('rights'), "Access Prescription") !== false) {
                $this->render('Prescription/records');
            } else {
                $this->render('errors/custom/access');
            }
        }

        public function search(){
                $user = $this->ion_auth->user()->row();
                $username = $user->username;
                $date = explode('-', $this->input->post('daterange'));
                $startdate = str_replace('/','-',str_replace(" ", "", $date[0]));
                $enddate = str_replace('/','-',str_replace(" ", "", $date[1]));
                $this->db->where('date >=', $startdate);
                $this->db->where('date <=', $enddate);
                $sql = $this->db->get('triage');
                $response = $sql->result();
                $this->mViewData['prescription'] = $response; //$this->triage_model->get_date_range($startdate,$enddate);
                $this->render('Prescription/records');
        }

        public function print($id, $pid) {
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $username));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['prescription'] = $this->prescription_model->get_by_id($id);
            $this->mViewData['patient'] = $this->patients_model->get_by_id($pid);
            
            $data = array (
                'status' => 'Dispensed',
                'dispensed_by' => $username,
                );
            
            $this->db->where('id',$id);
            $this->db->update('prescription', $data);

            $data['id'] = $id;
            $data['pid'] = $pid;
            
            $this->render('Prescription/print');
        }
        
        public function view($id){
           $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['prescription'] = $this->prescription_model->get_by_id($id); 
            $this->render('Prescription/edit');
        }
        
        public function add() {
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['patients'] = $this->patients_model->get_all();
            $this->render('Prescription/add');
        }
        
        public function save() {
            //Logged In User
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $date = date('Y-m-d');
            
             //Validation
            $this->load->helper(array('form', 'url'));
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('', '');
            $this->form_validation->set_rules('id', 'Patient Name', 'required');
            $this->form_validation->set_rules('prescription', 'Prescription', 'required');
            if ($this->form_validation->run() == FALSE) {
                echo validation_errors();
            } else {
            $patient_id = $this->input->post('id');
            $pieces = explode(" ", $patient_id);
            $id = $pieces[sizeof($pieces) - 1];
            
            $data = array (
                'patient_id' => $id,
                'prescription' => $this->input->post('prescription'),
                'notes' => $this->input->post('notes'),
                'date' => $date,
                'record_creator' => $user->username,
                );
            $res = $this->prescription_model->save($data);
            $insert_id = $this->db->insert_id();
            if ($res == true) {
                $this->session->set_flashdata('success', "Recor added Successfully");
                     redirect('admin/prescription');
                } else {
                    $this->session->set_flashdata('error', "Record Not Inserted");
                    redirect('admin/prescription');
                }    
            }
        }
        
        public function update() {
             //Logged In User
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            
            $prescription = $this->input->post('prescription');
            $notes = $this->input->post('notes');
            $id = $this->input->post('id');
            
            
            $data = array (
                'prescription' => $prescription,
                'notes' => $notes,
                );
            echo $data;
            $this->db->where('id', $id);
            $res =  $this->db->update('laboratory', $data);
            if ($res == true) {
                $this->session->set_flashdata('success', "Record Updated Successfully");
                     redirect('admin/prescription');
                } else {
                    $this->session->set_flashdata('error', "Record Not Updated");
                    redirect('admin/prescription');
                }     
        }
        
     }
?>