<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Roles extends Admin_Controller {
    public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
		$this->load->model('roles_model');
        
	}

	public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['roles'] = $this->roles_model->get_all();
        $this->render('Roles/index');
    }

    public function add() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['roles'] = $this->roles_model->get_all();
        $this->render('Roles/add');
    }

    public function edit($id) {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['role'] = $this->roles_model->get_by_id($id);
        $this->render('Roles/edit');
    }

    public function save(){
        $user = $this->ion_auth->user()->row();
        $username = $user->username;

        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $rights = "";
        if (isset($_POST['rights'])) {
                $rights = ltrim(implode($_POST['rights'],";"), ";");
        }
        
        $data = array(
            'name' => $name,
            'rights' => $rights,
            'record_creator' => $username,
        );

        $response = $this->db->insert('admin_groups',$data);

        redirect('admin/roles');

    }

    public function update(){
        $user = $this->ion_auth->user()->row();
        $username = $user->username;

        $id = $this->input->post('id');
        $rights = "";
        if (isset($_POST['rights'])) {
                $rights = ltrim(implode($_POST['rights'],";"), ";");
        }
        
        $data = array(
            'rights' => $rights,
        );

        $this->db->where('id',$id);
        $this->db->update('admin_groups',$data);

       redirect('admin/roles');

    }

    public function select_role() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
    }
}
?>