<?php
     defined('BASEPATH') OR exit('No direct script access allowed');
    class Services extends Admin_Controller {
        public function __construct() {
            parent::__construct();
            $this->load->library('form_builder');
            $this->load->library('excel');
            $this->load->model('services_model');
        }
        
        public function index(){
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['services'] = $this->services_model->get_all();
            $this->render('Services/index');
        }
        
        public function add(){
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->render('Services/add');
        }
        
        public function save(){
            //Logged In User Session
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            
            $data = array (
                'code' => $this->input->post('code'),
                'description' => $this->input->post('description'),
                'price' => $this->input->post('price'),
                'record_created' => $username,
            );
            $res = $this->services_model->save($data);
            if ($res == true) {
             $this->session->set_flashdata('success', "Record added Successfully");
                 redirect('admin/services');
            } else {
                $this->session->set_flashdata('error', "Record Not Inserted");
                redirect('admin/services');
            }
            
        }
        
    }
?>