<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require_once (APPPATH . 'libraries/AfricasTalkingGateway.php');
class Sms extends Admin_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('sms_model');
    }
    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['messages'] = $this->sms_model->get_all_sms();
        $this->render('_layouts/sms');
    }
    
     public function landlords() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['messages'] = $this->sms_model->get_alllandlords_sms();
        $this->render('_layouts/landlords_sms');
    }
    
     public function landlords_sms() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['messages'] = $this->sms_model->get_alllandlords_sms();
        $this->render('_layouts/landlords_sms_add');
    }
        public function tenants() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['messages'] = $this->sms_model->get_alltenants_sms();
        $this->render('_layouts/tenants_sms');
    }
    
    public function tenants_sms() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['messages'] = $this->sms_model->get_alltenants_sms();
        $this->render('_layouts/tenants_sms_add');
    }
    
    
    public function sms_add() {
        $query = $this->db->get('sms_settings');
        $apiusername = $query->row('api_username');
        $apisenderid = $query->row('api_sender_id');
        $api_key = $query->row('api_key');
        // Specify your authentication credentials
        $username = $apiusername;
        $apikey = $api_key;
        // Specify the numbers that you want to send to in a comma-separated list
        // Please ensure you include the country code (+254 for Kenya in this case)
        $recipients = $this->input->post('phone');
        // And of course we want our recipients to know what we really do
        $message = $this->input->post('message');
        $from = $apisenderid;
        // Create a new instance of our awesome gateway class
        $gateway = new AfricasTalkingGateway($username, $apikey);
        $results = $gateway->sendMessage($recipients, $message, $from);
        foreach ($results as $result) {
            // status is either "Success" or "error message"
            // $phone=$result->number;
            $status = $result->status;
            $cost = $result->cost;
        }
        $data = array('status' => $status, 'message' => $this->input->post('message'), //,
        // 'cost' => $cost,
        'phone' => $this->input->post('phone'), 'time' => date('Y-m-d H:i:s'), 'status' => $status,);
        $insert = $this->sms_model->sms_add($data);
        echo json_encode(array("status" => TRUE));
    }
    public function ajax_edit($id) {
        $data = $this->customers_model->get_by_id($id);
        echo json_encode($data);
    }
     
    public function sms_delete($id) {
        $this->sms_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }
    
    function landlord_bulk_sms() {
        
        $property = $this->input->post('property_id');
        
        $query = $this->db->get_where('property', array('id'=>$property));
        
        foreach($query->result() as $row){
            $landlord_id = $query->row('landlord_id');
            $query = $this->db->get_where('landlord', array('id'=>$landlord_id));
           
            $recipients ='254'.$query->row('phone');
            
            $query = $this->db->get('sms_settings');
            $apiusername = $query->row('api_username');
            $apisenderid = $query->row('api_sender_id');
            $api_key = $query->row('api_key');
            $username = $apiusername;
            $apikey = $api_key;  
            $from = $apisenderid;
            $gateway = new AfricasTalkingGateway($username, $apikey); 
            $message = $this->input->post('message');

             $results = $gateway->sendMessage($recipients, $message, $from);
              foreach ($results as $result) {
                  $data= array(
                      
                 'phone'=> $result->number,
                 'status'  => $result->status,
                 'message' => $message,
                 'cost' => $result->cost
                );
                $this->db->insert('sms',$data);
            }
        }
        
        redirect('admin/sms/landlords');
    }
    
     function tenants_bulk_sms() {
        
        $property = $this->input->post('property_id');
        $type = $this->input->post('type');
        
        
        $query = $this->db->get('sms_settings');
        $apiusername = $query->row('api_username');
        $apisenderid = $query->row('api_sender_id');
        $api_key = $query->row('api_key');
        $username = $apiusername;
        $apikey = $api_key;  
        $from = $apisenderid;
        
        if($type == 'General'){
            $this->db->where('property_id', $property);
            $this->db->from('tenants');
            $query = $this->db->get();
             foreach($query->result() as $row){
                
                $phone = $row->phone;
                $recipients ='254'.$phone;
                $gateway = new AfricasTalkingGateway($username, $apikey); 
                $message = $this->input->post('message');
                
                $results = $gateway->sendMessage($recipients, $message, $from);
                  foreach ($results as $result) {
                      $data= array(
                     'phone'=> $result->number,
                     'status'  => $result->status,
                     'message' => $message,
                     'cost' => $result->cost
                    );
                    $this->db->insert('sms',$data);
                }
            }
        } else if($type == 'Reminder'){
            $this->db->where('balance >', 0);
            $this->db->from('invoices');
            $query = $this->db->get();
            
            foreach($query->result() as $row){
                $id = $row->tenant_id;
                $sql = $this->db->get_where('tenants', array('id' => $id));
                
                  foreach($sql->result() as $item){
                      $phone = $item->phone;
                  }
                
                
                $recipients ='254'.$phone;
                $gateway = new AfricasTalkingGateway($username, $apikey); 
                $message = $this->input->post('message');
                
                echo $phone. '\n';
    
                 $results = $gateway->sendMessage($recipients, $message, $from);
                  foreach ($results as $result) {
                      $data= array(
                     'phone'=> $result->number,
                     'status'  => $result->status,
                     'message' => $message,
                     'cost' => $result->cost
                    );
                    $this->db->insert('sms',$data);
                }
            }
         }
        
       //redirect('admin/sms/tenants');
    }
    
    
    public function invoice_links() {
        $this->render('_layouts/invoice_links');
    }
    public function sendTenantInvoicesSms($id) {
        $query = $this->db->get('sms_settings');
        $apiusername = $query->row('api_username');
        $apisenderid = $query->row('api_sender_id');
        $api_key = $query->row('api_key');
        
        //
        $query = $this->db->get_where('invoices', array('balance >' => 0, 'invoice_number' => $id));
        foreach ($query->result() as $row) {
            $tenantid = $row->tenant_id;
            $id = $row->invoice_number;
            $amount = $row->balance;
            $description = $row->description;
            $rent = $amount;
            $month = $row->month;
            $query = $this->db->get_where('tenants', array('id' => $tenantid));
            $phone = $query->row('phone');
            // Send sms link
            $username = $apiusername;
            $apikey = $api_key;
            $recipients = '+254' . $phone;
            // And of course we want our recipients to know what we really do
             $message = 'Your invoice of Ksh' .$rent. ' for '. $description .' is ready. To pay click https://portal.geomarahomes.co.ke/home/payinvoice/' . $id;
             
            $from = $apisenderid;
            // Specify your AfricasTalking shortCode or sender id
            $gateway = new AfricasTalkingGateway($username, $apikey);
            try {
                $results = $gateway->sendMessage($recipients, $message, $from);
                foreach ($results as $result) {
                      $data= array(
                     'phone'=> $result->number,
                     'status'  => $result->status,
                     'message' => $message,
                     'cost' => $result->cost
                    );
                    $this->db->insert('sms',$data);
                }
            }
            catch(AfricasTalkingGatewayException $e) {
                echo "Encountered an error while sending: " . $e->getMessage();
            }
        }
    }
    
    public function sendinvoicesms() {
        $query = $this->db->get('sms_settings');
        $apiusername = $query->row('api_username');
        $apisenderid = $query->row('api_sender_id');
        $api_key = $query->row('api_key');
        
        //
        $query = $this->db->get_where('invoices', array('balance >' => 0));
        foreach ($query->result() as $row) {
            $tenantid = $row->tenant_id;
            $id = $row->invoice_number;
            $amount = $row->amount;
            $query = $this->db->get_where('tenants', array('id' => $tenantid));
            $phone = $query->row('phone');
            // Send sms link
            $username = $apiusername;
            $apikey = $api_key;
            $recipients = '+254' . $phone;
            // And of course we want our recipients to know what we really do
            $message = 'Hello, Click on this link to pay your rent invoice of '. $amount .'. https://sandbox.jambosales.co.ke/home/payinvoice/' . $id;
            echo $message;
            $from = $apisenderid;
            // Specify your AfricasTalking shortCode or sender id
            $gateway = new AfricasTalkingGateway($username, $apikey);
            try {
                $results = $gateway->sendMessage($recipients, $message, $from);
                foreach ($results as $result) {
                    echo " Number: " . $result->number;
                    echo " Status: " . $result->status;
                    echo " StatusCode: " . $result->statusCode;
                    echo " MessageId: " . $result->messageId;
                    echo " Cost: " . $result->cost . "\n";
                }
            }
            catch(AfricasTalkingGatewayException $e) {
                echo "Encountered an error while sending: " . $e->getMessage();
            }
        }
    }
}
