<h5>Consultation Records</h5>
<div class="container">
    <!-- Content Header (Page header) -->
    <fieldset>
        <?php echo form_open('admin/consultation/search'); ?>
        <div class="row">
            <div class="col-sm-3">
                <label class="control-label">Patient Search :</label>
                <input type="text" name="name" class="form-control float-right" id="name">
            </div>
            <div class="col-sm-6">
            </div>
            <div class="col-sm-3">
                <label class="control-label">Date Range :</label>
                <input type="text" name="daterange" class="form-control float-right" id="reservation">
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-md-3">
                <button type="submit" class=" btn btn-success btn-block"> Search </button>
            </div>
        </div>
        </form>
    </fieldset>
    <br>
    <section class="content">
        <div class="row ">
            <div class="col-md-12">
                <div class="table-responsive no-padding">
                    <table id="example1" class="table table-striped table-bordered" cellspacing="0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Date </th>
                                <th>Patient</th>
                                <th>Age</th>
                                <th>Gender</th>
                                <th>Consulting Doctor</th>
                                <th style="width:125px;">Action</th </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i = 1;
                            foreach ($records as $record) {
                                $sql = $this->db->get_where('patient', array('id' => $record->patient_id));
                                $p_number = $sql->row('patient_number');
                                $dob = $sql->row('dob');
                                $name = $sql->row('name');
                                $b_g = $sql->row('blood_group');
                                $gender = $sql->row("gender");
                                $from = new DateTime($dob);
                                $to   = new DateTime('today');
                                $age = $from->diff($to)->y;; ?>
                                <tr>
                                    <td><?php echo $i ?></td>
                                    <td><?php echo $record->date ?></td>
                                    <td><a href="<?php echo base_url(); ?>admin/patients/account/<?php echo $record->patient_id; ?>"><?php echo $name ?></a></td>
                                    <td><?php echo $age ?></td>
                                    <td><?php echo $gender ?></td>
                                    <td><?php echo $record->record_creator ?></td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-success btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <?php

                                                ?>
                                                <?php
                                                if (strpos($rights, "Edit Clinical Record") !== false) { ?>
                                                    <a class="dropdown-item" href="<?php echo base_url(); ?>admin/consultation/edit/<?php echo $record->visit_id ?>">Edit Record</a>
                                                <?php } ?>
                                                <a class="dropdown-item" href="<?php echo base_url(); ?>admin/reports/patientrecord/<?php echo $record->visit_id ?>/<?php echo $record->patient_id; ?>">View Pdf</a>
                                                <a class="dropdown-item" href="<?php echo base_url(); ?>admin/consultation/queue/<?php echo $record->patient_id ?>">Queue Patient</a>
                                                <?php
                                                if (strpos($rights, "Delete Clinical Record") !== false) {?>
                                                    <a class="dropdown-item" href="javascript:void(0);" onclick="delete_record(<?php echo $record->id ?>)">Delete Record</a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php
                                $i++;
                            } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
</div>

</section>
</div>
<script>
    $(document).ready(function() {
        $('#example2').DataTable({
            order: [
                [0, 'desc']
            ],
        });
        $('#reservation').daterangepicker({
            locale: {
                format: 'Y/MM/DD'
            }
        });
    });
</script>
<script>
    function delete_record(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "<?php echo site_url('admin/Consultation/delete_record') ?>/" + id,
                    type: "POST",
                    dataType: "JSON",
                    success: function(data) {
                        Swal.fire(
                            'Deleted!',
                            'Record Deleted Successfully.',
                            'success'
                        )
                        location.reload();
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(id);
                        swal.fire("!Opps ", "Something went wrong, try again later", "error");
                    }
                });

            }
        })
    }
</script>

<script>
    $(function() {
        $("#example1").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "searching": true,
            "paging": true,
            "order": [
                [0, 'desc']
            ],
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        $('#example2').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
        });
    });
</script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<link rel="stylesheet" href="/resources/demos/style.css">
<script src="https://code.jquery.com/jquery-3.6.0.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script type="text/javascript">
    $(function() {
        $("#name").autocomplete({ //the recipient text field with id #username
            source: function(request, response) {
                $.ajax({
                    url: "<?php echo site_url('admin/patients/patient_search') ?>/",
                    dataType: "json",
                    data: request,
                    success: function(data) {
                        if (data.response == 'true') {
                            response(data.message);
                        }
                    }
                });
            },
            select: function(event, ui) {
                var id = ui.item.value;
                const str = id;
                const pieces = str.split(" ");
                const value = pieces[pieces.length - 1]

                window.location = "patients/account/" + value;
            }
        });
    });
</script>