<div class="container">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-building"></i> Properties
        </h1>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12 text-right">
                <div class="form-group">
                    <a class="btn btn-primary" href="properties/add"><i class="fa fa-plus"></i> Add Property </a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-body table-responsive no-padding">
                        <table id="example2" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>BRANCH</th>
                                    <th>LANDLORD</th>
                                    <th>PROPERTY</th>
                                    <th>LOCATION</th>
                                    <th>TYPE</th>
                                    <th>COMMISSION % </th>
                                    <th style="width:125px;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($properties as $property) { ?>
                                    <tr>
                                        <td><?php echo $property->id; ?> </td>
                                        <td>
                                            <?php
    $query = $this->db->get_where('offices', array('id' => $property->branch_id));
    foreach ($query->result() as $row) {
        echo $row->name;
    }; ?> 
                                    </td>

                                        <td>

                                            <?php
    $query = $this->db->get_where('landlord', array('id' => $property->landlord_id));
    foreach ($query->result() as $row) {
        echo $row->fullname;
    }; ?> 
                    </td>



 
                                        <td><?php echo $property->property_name; ?> </td>
                                        <td><?php echo $property->location; ?> </td>
                                        <td><?php echo $property->property_type; ?> </td>
                                        <td><?php echo $property->commission; ?> %</td>
                                        <td>
                                            <?php if ($usergroup == 1 || $usergroup == 2) { ?>
                                             <div class="dropdown">
                                                                  <button class="btn btn-success btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                    Actions
                                                                  </button>
                                                                  <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                                   <a class="dropdown-item" href="<?php echo base_url(); ?>admin/properties/edit/<?php echo $property->id; ?>  ?>">Update Property Info</a>
                                                                    <a class="dropdown-item" href="<?php echo base_url(); ?>admin/properties/view_property/<?php echo $property->id; ?>">View Property</a>
                                                                    <a class="dropdown-item" href="<?php echo base_url(); ?>admin/properties/view_report/<?php echo $property->id; ?>">View Report</a>
                                                                 </div>
                                                                </div>
                                                
                                            <?php
    } else { ?>
 <a class="dropdown-item" href="<?php echo base_url(); ?>admin/properties/view_property/<?php echo $property->id; ?>">View Property</a>

                                                
                                            <?php
    } ?>
                                        </td>
                                    </tr>
                                <?php
} ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                </tr>
                            </tfoot>
                        </table>

                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div>
        </div>
    </section>
</div>
<script>
    function toTitleCase(str) {
        return str.replace(/\w*/g, function (txt) {
            return txt.charAt().toUpperCase() + txt.substr(1).toLowerCase();
        });
    }
</script>
<script>
    $(document).ready(function () {
        $("input[type='text']").blur(function () {
            var str = toTitleCase($(this).val());
            str = str.replace(/\s+/g, " ");
            str = str.replace(/(^\s+|\s+$)/g, "");
            $(this).val(str);
        });
    });</script>
<script>
    function isNumber(evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    }
</script>
<script type="text/javascript">
    
    var save_method; //for save method string
    var table;


    function add_property()
    {
        save_method = 'add';
        $('#form')[0].reset(); // reset form on modals
        $('#modal_form').modal('show'); // show bootstrap modal
        //$('.modal-title').text('Add Person'); // Set Title to Bootstrap modal title
    }

    function edit_property(id)
    {
        save_method = 'update';
        $('#form')[0].reset(); // reset form on modals

        //Ajax Load data from ajax
        $.ajax({
            url: "<?php echo site_url('admin/properties/ajax_edit/') ?>/" + id,
            type: "GET",
            dataType: "JSON",
            success: function (data)
            {

                $('[name="property_name"]').val(data.property_name);
                $('[name="landlord_id"]').val(data.landlord_id);
                $('[name="location"]').val(data.location);
                $('[name="commission"]').val(data.commission);
                $('[name="property_type"]').val(data.property_type);
                $('[name="office_branch"]').val(data.branch_id);
                $('[name="water_deposit"]').val(data.water_deposit);
                $('[name="electricity_deposit"]').val(data.electricity_deposit);
                $('[name="id"]').val(data.id);
                $('#modal_form').modal('show'); // show bootstrap modal when complete loaded
                $('.modal-title').text('Edit property'); // Set title to Bootstrap modal title

            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error get data from ajax');
            }
        });
    }



    function save()
    {
        var url;
        if (save_method == 'add')
        {
            url = "<?php echo base_url('admin/properties/property_add') ?>";
        } else
        {
            url = "<?php echo site_url('admin/properties/property_update') ?>";
        }

        // ajax adding data to database
        $.ajax({
            url: url,
            type: "POST",
            data: $('#form').serialize(),
            dataType: "JSON",
            success: function (data)
            {
                //if success close modal and reload ajax table
                $('#modal_form').modal('hide');
                location.reload();// for reload a page
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error adding / update data');
            }
        });
    }

    function delete_property(id)
    {
        if (confirm('Are you sure delete this data?'))
        {
            // ajax delete data from database
            $.ajax({
                url: "<?php echo site_url('admin/properties/property_delete') ?>/" + id,
                type: "POST",
                dataType: "JSON",
                success: function (data)
                {

                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert('Error deleting data');
                }
            });

        }
    }
</script>
<script>
  $(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>
<!-- Bootstrap modal -->
<div class="modal fade " id="modal_form" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h3 class="modal-title">Add New property</h3>
            </div>
            <div class="modal-body form">
                <form action="#" id="form" class="form-horizontal">
                    <input type="hidden" value="" name="id"/>
                    <div class="form-body">
                        <div class="form-group">
                            <label class="control-label col-md-3">Property Name *</label><br>
                            <div class="col-md-9">
                                <input name="property_name" id="pName"  class="form-control" type="text" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Property Location *</label><br>
                            <div class="col-md-9">
                                <input name="location"  class="form-control" type="text" required>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Property Type *</label><br>
                            <div class="col-md-9">
                                <select class="form-control" name="property_type" required>
                                    <option value="">--Select Type--</option>
                                    <?php
                                        $query = $this->db->get('propertytypes');
                                            foreach ($query->result() as $row) {
                                            ?>
                                        <option><?php echo $row->name; ?></option>
                                    <?php
                                    } ?>
                                </select>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Property Landlord *</label><br>
                            <div class="col-md-9">
                                <select name="landlord_id" class="form-control" required="">
                                    <option value="">--Select Landlord--</option>
                                    <?php
$query = $this->db->get('landlord');
foreach ($query->result() as $row) {
?>
                                        <option value="<?php echo $row->id ?>"><?php echo $row->fullname; ?></option>
                                    <?php
} ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Office Branch *</label><br>
                            <div class="col-md-9">
                                <select name="office_branch" class="form-control" required="">
                                    <option value="">--Select Office--</option>
                                    <?php
                                    $query = $this->db->get('offices');
                                    foreach ($query->result() as $row) {
                                    ?>
                                        <option value="<?php echo $row->id; ?>"><?php echo $row->name; ?></option>
                                    <?php
                                } ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Commission in Percentage *</label><br>
                            <div class="col-md-9">
                                <input name="commission" onkeypress="return isNumber(event)"  class="form-control" type="number" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Water Deposit</label><br>
                            <div class="col-md-9">
                                <input name="water_deposit" onkeypress="return isNumber(event)"  class="form-control" type="number" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Electricity Deposit</label><br>
                            <div class="col-md-9">
                                <input name="electricity_deposit" onkeypress="return isNumber(event)"  class="form-control" type="number" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="btnSave" onclick="save()" class="btn btn-primary">Save</button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- End Bootstrap modal -->
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
