<?php

    $yr =  date('Y');
    $mnth =  date('m');
            
        
    class MYPDF extends TCPDF {
        

        
    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('times', 'I', 10);
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Joel Mwas');
$pdf->SetTitle(' receipt');
$pdf->SetSubject('Payment Report');
$pdf->SetKeywords('Payment Report');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 10);

// set cell padding
$pdf->setCellPaddings(1, 1, 1, 1);

// set cell margins
$pdf->setCellMargins(1, 1, 1, 1);

// add a page
$pdf->AddPage();


// -----------------------------------------------------------------------------

$html = '<div style="text-align:center; "><h2><u>PAYMENTS REPORT</u> </h2>
  <br>

<h3> From Date : <b>' .$start. ' </b> To Date :<b>' .$end. '</b> </h3>
</div>';
$pdf->writeHTML($html, true, false, true, false, '');


$html = '<hr>';
$pdf->writeHTML($html, true, false, true, false, '');



// -----------------------------------------------------------------------------

$tbl_header = '
<table style="text-align:center;" cellspacing="0" cellpadding="1" border="0.1"  rowspan="5"  >


<tr cellpadding="2" border="1" >

    <th><b>DATE</b></th>
    <th><b>AMOUNT</b></th>
    <th><b>METHOD</b></th>
    <th><b>PAYMENT REF</b></th>
    
   
</tr>

';

$tbl_footer = '</table>';
$tbl = '';
$this->db->order_by("id", "asc");
  $query = $this->db->get_where('invoicepayments', array('Date >=' => $start, 'Date <=' => $end)); 

// foreach item in your array...
  foreach ($query->result() as $row)    {
      
     
$tbl .= '
 <tr>
        <td style="border: 1px solid #000000; ">'.$row->date.'</td>
        <td style="border: 1px solid #000000; ">00'.$row->id.'</td>
        <td style="border: 1px solid #000000; ">'.$row->customer.'</td>
        <td style="border: 1px solid #000000; ">'.$row->service.'</td>
        <td style="border: 1px solid #000000; ">'.$row->subtotal.' </td>
        <td style="border: 1px solid #000000; ">'.$row->vat_amount.'<br><i>'.$row->vat_type.'</i></td>
        <td style="border: 1px solid #000000; ">'.$row->amount.'</td>
        


</tr>
    
';
      

}

$pdf->writeHTML($tbl_header. $tbl  . $tbl_footer, true, false, false, false, '');

 
// -----------------------------------------------------------------------------


$tbl = <<<EOD
<table cellspacing="0" cellpadding="1" border="0"  rowspan="8" style=" background-color: #C4C6C4  ;  text-align:center;">
    <tr>
    <th></th>
    <th></th>
    <th><b>TOTAL AMOUNT</b><br> <b> Ksh $total </b> </th>
    <th></th>
    <th></th>
  

    </tr>
 
 
</table>
EOD;

$pdf->writeHTML($tbl, true, false, false, false, '');

// -----------------------------------------------------------------------------



$html = '<div><br><br><i>Received By:  .................................................................. Sign .....................................................................</div>';
$pdf->writeHTML($html, true, false, true, false, '');




$html = '<i>Authorised Signature ....................................................................................................................................</i></div>';
$pdf->writeHTML($html, true, false, true, false, '');



//Close and output PDF document
$pdf->Output('Invoice Payment Report.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
  
  